(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    121857,       3843]*)
(*NotebookOutlinePosition[    122579,       3868]*)
(*  CellTagsIndexPosition[    122535,       3864]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(HFT\)], "Title",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Initialization\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(If[$VersionNumber < 4, 
      Print["\<This package will not work correctly with versions of \
Mathematica earlier than Mathematica 4.0. If you need a version of this \
package that will work correctly with earlier versions of Mathematica, please \
contact Sheldon Axler at axler@sfsu.edu.\>"]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Print["\<HFT; Version 6.10, 9 August 2003\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Print["\<This Mathematica package, called HFT.m, is designed for \
computing with harmonic functions. Documentation for the use of this package \
and information about the algorithms used in it is available in the \
Mathematica notebook called HFT.nb.\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Print["\<For addional information about harmonic functions, see the \
book Harmonic Function Theory, by Sheldon Axler, Paul Bourdon, and Wade \
Ramey, published by Springer.\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Print["\<This package is copyrighted by Sheldon Axler but is \
distributed without charge. The most recent version of this HFT.m package \
along with its documentation notebook HFT.nb is available over the world wide \
web at: http://www.axler.net\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Print["\<Comments, suggestions, and bug reports should be sent by \
electronic mail to: axler@sfsu.edu\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Print["\<* The computer is now unpacking the HFT.m package.\>"]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(BeginPackage["\<HFT`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Usage\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Annulus::"\<usage\>" = "\<Annulus is an option for Region in Dirichlet.\
\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(AntiLaplacian::"\<usage\>" = "\<AntiLaplacian[f, x] gives a polynomial \
\>" <> "\<whose Laplacian equals f.  \>" <> "\<Here f must be a polynomial \
function of x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Ball::"\<usage\>" = "\<Ball is one of the values that may be assigned \
to the option \>" <> "\<Orthonormal.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BasisH::"\<usage\>" = "\<BasisH[m, x] gives a basis for the space of \
harmonic \>" <> "\<polynomials homogeneous of degree m in the variable \
x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanKernel::"\<usage\>" = "\<BergmanKernel[x, y] gives the Bergman \
\>" <> "\<reproducing kernel for the unit ball.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanKernelH::"\<usage\>" = "\<BergmanKernel[z, w] gives the Bergman \
\>" <> "\<reproducing kernel for the upper half-space.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanProjection::"\<usage\>" = "\<BergmanProjection[ f, x] gives the \
\>" <> "\<orthogonal projection of a polynomial f, as a function of x, \>" <> \
"\<onto the Bergman space of harmonic functions on the ball.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BiDirichlet::"\<usage\>" = "\<BiDirichlet[f , x] solves the \>" <> \
"\<BiDirichlet problem with boundary data f, \>" <> "\<as a function of x.\>"\
\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Delta::"\<usage\>" = "\<Delta[j] is the vector that equals 1 in the \
j-th \>" <> "\<coordinate and 0 in the other coordinates.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension::"\<usage\>" = "\<Dimension[x] is the dimension of the vector \
x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(DimensionH::"\<usage\>" = "\<DimensionH[m, n] gives the vector space \
dimension of the \>" <> "\<space of spherical harmonics of degree m in n \
variables.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dirichlet::"\<usage\>" = "\<Dirichlet[f, x] gives the harmonic function \
\>" <> "\<that equals f on the unit sphere.  Here f must be a \>" <> \
"\<polynomial function of x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence::"\<usage\>" = "\<Divergence[f, x] gives the divergence of f \
\>" <> "\<with respect to x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(DoubleBracketingBar::"\<usage\>" = "\<DoubleBracketingBar is equal to \
the Norm.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExpandNorm::"\<usage\>" = "\<ExpandNorm[f] gives f with all terms of \
the form |x + y| \>" <> "\<replaced by Sqrt[ |x|^2 + |y|^2 + 2 x.y ].\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExteriorSphere::"\<usage\>" = "\<ExteriorSphere is an option for \
Dirichlet, \>" <> "\<specifying that the region should be the exterior \>"\  \
<> \[IndentingNewLine]"\<of the unit sphere.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExteriorNeumann::"\<usage\>" = "\<ExteriorNeumann[f , x] solves the \>" \
<> "\<exterior Neumann problem with boundary data f, \>" <> "\<as a function \
of x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad::"\<usage\>" = "\<Grad[f, x] gives the gradient of f with \>" <> "\
\<respect to x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(HarmonicConjugate::"\<usage\>" = "\<HarmonicConjugate[u, x, y] gives \
\>" <> "\<the harmonic conjugate of u with respect to the variables x, \
y.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(HarmonicDecomposition::"\<usage\>" = "\<HarmonicDecomposition[u, x] \>" \
<> "\<gives the harmonic decomposition of u with respect to \>" <> "\<the \
variable x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(HilbertSchmidt::"\<usage\>" = "\<HilbertSchmidt[A] gives the \>" <> \
"\<HilbertSchmidt norm of a matrix A.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous::"\<usage\>" = "\<Homogeneous[f, d, x] gives the homogenous \
\>" <> "\<part of f of degree d, with respect to x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Hyperplane::"\<usage\>" = "\<Hyperplane[b, c] denotes the hyperplane \
\>" <> "\<b.x = c.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateBall::"\<usage\>" = "\<IntegrateBall[f, x] gives the integral \
\>" <> "\<of f, as a function of x, over the unit ball.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateSphere::"\<usage\>" = "\<IntegrateSphere[f, x] gives the \>" <> \
"\<integral of f, as a function of x, over the unit sphere \>" <> "\<with \
respect to normalized surface area measure.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection::"\<usage\>" = "\<Reflection[x] gives the reflection of x \
\>" <> \[IndentingNewLine]"\<in the unit sphere.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J::"\<usage\>" = "\<J[f, x] gives the Jacobian of f with \>" <> \
"\<respect to x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Kelvin::"\<usage\>" = "\<Kelvin[u, x] gives the Kelvin transform of u, \
\>" <> "\<thought of as a function of x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(KelvinM::"\<usage\>" = "\<KelvinM is the modified Kelvin transform, \>" \
<> "\<as defined in Chapter 7 of Harmonic Function Theory.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian::"\<usage\>" = "\<Laplacian[f, x] gives the Laplacian of f \
\>" <> "\<with respect to x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Multiple::"\<usage\>" = "\<Multiple is an option for AntiLaplacian.  \
\>" <> "\<The default value is None.  The value Norm^2 produces the \>" <> \
"\<unique antiLaplacian that is a polynomial multiple of \>" <> "\<Norm[x]^2, \
where x is the variable.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Neumann::"\<usage\>" = "\<Neumann[f, g, x] solves the \>" <> "\<Neumann \
problem of finding a function of x whose \>" <> "\<outward normal derivative \
(on the unit sphere) is f \>" <> "\<and whose Laplacian is g.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(If[$VersionNumber\  < \ 5, 
      Norm::"\<usage\>" = "\<Norm[x] gives the Euclidean norm of x.\>"]\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(NormalD::"\<usage\>" = "\<NormalD[f, z] gives the outward normal \
derivative of f, \>" <> "\<as a function of z, with respect to the unit ball.\
\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Orthonormal::"\<usage\>" = "\<Orthonormal is an option for BasisH.  \>" \
<> "\<The default value is None.  The value Ball produces a \>" <> "\<basis \
that is orthonormal with respect to volume measure \>" <> "\<on the ball.  \
The value Sphere produces a \>" <> "\<basis that is orthonormal with respect \
to surface area \>" <> "\<measure on the sphere.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial::"\<usage\>"\  = \ \*"\"\<Partial[f, \!\(x\_j\)] gives the \
partial derivative \>\"" <> \*"\"\<of f with respect to \!\(x\_j\).\>\""\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\[CapitalPhi]::"\<usage\>" = "\<\[CapitalPhi][z] is the modified \
reflection defined in \>" <> "\<Chapter 7 of Harmonic Function Theory.\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(PoissonKernel::"\<usage\>" = "\<PoissonKernel[x, z] gives the Poisson \
kernel for the unit ball.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(PoissonKernelH::"\<usage\>" = "\<PoissonKernelH[x, y, t] gives the \>" <> \
"\<Poisson kernel for the upper half-space.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Quadratic::"\<usage\>" = "\<Quadratic is an option for Multiple \>" \
<> \[IndentingNewLine]"\<in AntiLaplacian and for Region in Dirichlet.\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Region::"\<usage\>" = "\<Region is an option for Dirichlet.\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(S::"\<usage\>" = "\<S is the south pole.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Schwarz::"\<usage\>" = "\<Schwarz[x] gives the maximum of |u[x]|, where \
\>" <> "\<u ranges over all harmonic functions on the unit ball with \>" <> "\
\<u[0] = 0 and |u| < 1.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SetDimension::"\<usage\>" = "\<SetDimension[x, n] sets the Dimension of \
x to n.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Singularity::"\<usage\>" = "\<Singularity is an option for \
AntiLaplacian.  \>" <> "\<The default value is None.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Sphere::"\<usage\>" = "\<Sphere is one of the values that may be \
assigned to the option \>" <> "\<Orthonormal.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SurfaceArea::"\<usage\>" = "\<SurfaceArea[n] gives the surface area of \
\>" <> "\<the unit ball in n dimensional real Euclidean space.\>"\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Taylor::"\<usage\>" = "\<Taylor[f, d, x] gives the Taylor expansion of \
f \>" <> "\<to degree d, with respect to x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Togetherness::"\<usage\>" = "\<TurnOff[ Togetherness ] turns off the \
feature \>" <> "\<that simplifies some output.  TurnOn[ Togetherness ] turns \
\>" <> "\<this feature back on.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(TurnOff::"\<usage\>" = "\<TurnOff[F] turns feature F off.\>"\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(TurnOn::"\<usage\>" = "\<TurnOn[F] turns feature F on.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Volume::"\<usage\>" = "\<Volume[n] gives the volume of the unit ball in \
\>" <> "\<n-dimensional real Euclidean space.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZeroToZero::"\<usage\>" = "\<TurnOff[ ZeroToZero ] turns off the \
feature \>" <> "\<that changes 0. to 0 via $Post.  TurnOn[ ZeroToZero ] turns \
\>" <> "\<this feature back on.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZonalHarmonic::"\<usage\>" = "\<ZonalHarmonic[m, x, z] gives the \>" <> \
"\<zonal harmonic of degree m with pole x.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Protection\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Begin["\<`private`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Unprotect[IntegerQ, Limit, Transpose]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(protectedWords = 
      Unprotect[Abs, Dot, IdentityMatrix, Integer, Norm, \ Power, Times, \ 
        Tr]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \($Post\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SetAttributes[postTogether, HoldAll]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(postTogether[Apart[f_]] := Apart[f]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(postTogether[Together[f_]] := Together[f]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(postTogether[Simplify[f_]] := Simplify[f]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(postTogether[Expand[f_]] := Expand[f]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(postTogether[a_ = b_] := \(a = postTogether[b]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
shorter[f_] := With[ {g = Together[f]},
\tIf[ StringLength[ ToString[ Format[ g, InputForm ] ] ] < 
\tStringLength[ ToString[ Format[ f, InputForm ] ] ], g, f ] ]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(shorter /: f_Symbol[a___, \(HoldPattern[shorter]\)[x_], b___] := 
      f[a, x, b] /; 
        MemberQ[Attributes[f], HoldAll] || MemberQ[Attributes[f], HoldFirst] || 
          MemberQ[Attributes[f], HoldRest]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(postTogether[f_] := 
      Map[shorter, f, {0, \(-2\)}] //. \(HoldPattern[shorter]\)[j_] \[Rule] 
          j\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(zeroToZero[f_]\  := \ \((f\  /. \ 0. \  \[Rule] \ 0)\);\)\)], "Input",\

  InitializationCell->True],

Cell[BoxData[
    \(\(usersPost = 
        If[ToString[$Post] === "\<$Post\>", Identity, $Post];\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Togetherness::Off = "\<Togetherness has been turned off.  \>" <> "\<The \
command  TurnOn[Togetherness]  will turn it back on.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Togetherness::On = "\<Togetherness has been turned on.  \>" <> "\<The \
command  TurnOff[Togetherness]  will turn it back off.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Togetherness::AlreadyOn = "\<Togetherness is already turned on.\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Togetherness::AlreadyOff = "\<Togetherness is already turned \
off.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZeroToZero::Off = "\<ZeroToZero has been turned off.  \>" <> "\<The \
command  TurnOn[ZeroToZero]  will turn it back on.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZeroToZero::On = "\<ZeroToZero has been turned on.  \>" <> "\<The \
command  TurnOff[ZeroToZero]  will turn it back off.\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZeroToZero::AlreadyOn = "\<ZeroToZero is already turned on.\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZeroToZero::AlreadyOff = "\<ZeroToZero is already turned off.\>"\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(TurnOn[Togetherness] ^:= \ 
      If[\ togetherness\ , \ 
        Message[Togetherness::AlreadyOn], $Post = 
          If[zerotozero, 
            Composition[zeroToZero, \ postTogether, \ usersPost], 
            Composition[postTogether, usersPost]]; togetherness = True; \ 
        Message[Togetherness::On]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(TurnOn[ZeroToZero] ^:= \ 
      If[\ zerotozero\ , \ 
        Message[ZeroToZero::AlreadyOn], $Post = 
          If[togetherness, 
            Composition[zeroToZero, \ postTogether, \ usersPost], 
            Composition[zeroToZero, usersPost]]; zerotozero = True; \ 
        Message[ZeroToZero::On]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\($Post = 
        Composition[zeroToZero, \ postTogether, \ usersPost];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(togetherness = True; \ zerotozero\  = \ True;\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(TurnOff[ZeroToZero] ^:= \ 
      If[\ zerotozero\ , $Post = 
          If[togetherness, Composition[postTogether, usersPost], \ 
            usersPost]; zerotozero = False; 
        Message[ZeroToZero::Off], \ \ Message[
          ZeroToZero::AlreadyOff]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(TurnOff[Togetherness] ^:= \ 
      If[\ togetherness\ , $Post = 
          If[zerotozero, Composition[zeroToZero, usersPost], \ usersPost]; 
        togetherness = False; 
        Message[Togetherness::Off], \ \ Message[
          Togetherness::AlreadyOff]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Calculus\ on\ R\^n\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IdentityMatrix\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Off[IdentityMatrix::"\<intnm\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(matrix[IdentityMatrix[_]] ^= True;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IdentityMatrix /: a_\  . IdentityMatrix[_] := a\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IdentityMatrix /: IdentityMatrix[_] . v_ := v\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Off[Transpose::"\<nmtx\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(matrix[Transpose[_]] = True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[Transpose[x_]] := x\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[{c_\ x_?vector}] := c\ Transpose[{x}]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[c_\ x_?matrix] := c\ Transpose[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[IdentityMatrix[n_]] := IdentityMatrix[n]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[{0}] := {0}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tr\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Tr[IdentityMatrix[n_]] := n\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Tr[Transpose[A_]] := Tr[A]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Tr[c_\ A_] := c\ Tr[A] /; matrix[A]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Norm\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Format[Norm[x_], \ StandardForm]\  := \ 
      DoubleBracketingBar[x]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeExpression[
        RowBox[{"\<\[LeftDoubleBracketingBar]\>", \ 
            x_, \ "\<\[RightDoubleBracketingBar]\>"}], StandardForm]\ \  := \ 
      MakeExpression[RowBox[{"\<Norm\>", \ "\<[\>", \ x, \ "\<]\>"}], \ 
        StandardForm]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Norm[{x_?vector, y_}] := \((unmakeVector[
          y]; \@\(Norm[x]\^2 + y\^2\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(If[$VersionNumber\  < \ 5, \ Norm[x_List] := \@\(x . x\); \ 
      Norm[0]\  := 0]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Norm[c_\ x_?vector] := \((realize[c]; Abs[c]\ Norm[x])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Norm[x_] := 0 /; \((makeVector[x]; False)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Norm[c_?NumberQ\ x_] := Abs[c]\ Norm[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(real\ and\ realize\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(real\  = \ {};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(realize[c_]\  := \ \((real\  = \ real \[Union] {c})\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandNorm\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExpandNorm[f_] := 
      f //. Norm[
            g_ + h_] \[RuleDelayed] \@\(Norm[g]\^2 + Norm[h]\^2 + 2\ g . \
h\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Abs\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Abs[Norm[x_]\^p_. ] := Norm[x]\^p\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Abs /: Abs[x_\_j_]\^p_?EvenQ := x\_j\^p /; vector[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Abs /: Abs[c_]\^p_?EvenQ := 
      c\^p /; MemberQ[real, \ c]\  || MemberQ[real, 1/c] || 
          MemberQ[real, c\^\(p/2\)] || 
          MemberQ[real, 1\/c\^\(p/2\)] == 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vector\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[HoldPattern[\(+a__\)]] := 
      If[TrueQ[Or @@ Thread[vector[{a}]]], makeVector[\(+a\)]; 
        True]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[HoldPattern[Times[a__]]] := Or @@ Thread[vector[{a}]]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(vector[A_?matrix . x_?vector] := True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[x_?vector . Y_?matrix] := True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[a_["\<.\>", _]] := True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[a_[_, "\<.\>"]] := True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(0[j_] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[\(Partial\__[b_]\)[x_]] := True /; vector[b[x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[\(Grad[_]\)[_]] = True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(makeVector\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(vectors = {};\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(vectorValuedFunctions = {};\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(makeVector[x_Symbol] := 
      If[MemberQ[vectors, x], Null, x[j_] = x\_j; AppendTo[vectors, x]; 
        vector[x] ^= True;]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(makeVector[c_?NumberQ\ x_] := makeVector[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(makeVector[HoldPattern[\(+a__\)]] := makeVector /@ {a}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(makeVector[f_Symbol[_]]\), ":=", 
      RowBox[{
        RowBox[{"If", "[", 
          RowBox[{\(MemberQ[vectorValuedFunctions, f]\), ",", "Null", ",", 
            
            RowBox[{\(\(f[x_]\)[j_] = f\_j[x]\), ";", "\n", 
              "\t\t", \(AppendTo[vectorValuedFunctions, f]\), 
              ";", \(vector[f[_]] ^= True\), ";", 
              RowBox[{
                RowBox[{"vector", "[", 
                  RowBox[{
                    SuperscriptBox["f", 
                      TagBox[\((_)\),
                        Derivative],
                      MultilineFunction->None], "[", "_", "]"}], "]"}], "=", 
                "True"}], ";", \(vector[\(Partial\__[f]\)[_]] = True\), 
              ";"}]}], "]"}], "/;", \(f =!= List\)}]}]], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(makeVector[\(Partial\__[u_]\)[_]] := makeVector[u[_]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Attributes[unmakeVector] = {Listable};\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(unmakeVector[x_Symbol] := \ \((Unprotect[Abs]; 
        Abs /: Abs[x]\^p_?EvenQ := x\^p; 
        If[MemberQ[vectors, x], \((x[j$_])\) =. ; 
          vectors = 
            Delete[vectors, \(Position[vectors, x]\)\[LeftDoubleBracket]1, 
                1\[RightDoubleBracket]]; vector[x] ^= False;])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(matrix\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(matrix[HoldPattern[Times[a__]]] := Or @@ Thread[matrix[{a}]]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(matrix[HoldPattern[\(+a__\)]] := Or @@ Thread[matrix[{a}]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(matrix[a_?matrix . x_?matrix] := True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(matrix[\(J[_]\)[_]] = True;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(matrix[{_}] = True;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(0[_, _] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(matrix[Transpose[x_]] := matrix[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(makeMatrix\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(matrices = {};\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(makeMatrix[x_Symbol] := 
      If[TrueQ[matrix[x]], Null, x[j_, k_] = x\_\(j, k\); 
        AppendTo[matrices, x]; matrix[x] ^= True; 
        vector[x] ^= False]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dot\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Attributes[Dot] = {OneIdentity}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(b_\  . \ 0\  = \ 0;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(0\  . \ b_\  = \ 0;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(HoldPattern[\(+x__\)] . z_ := 
      Plus @@ \(\((#1 . z &)\) /@ {x}\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_\  . HoldPattern[\(+x__\)] := 
      Plus @@ \(\((a . #1 &)\) /@ {x}\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\((c_\ x_)\) . y_ := 
      c\ x . y /; vector[x] || matrix[x] || NumberQ[c]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \({c_\ x_} . y_ := 
      c\ {x} . y /; vector[x] || matrix[x] || NumberQ[c]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_\  . \((c_\ y_)\) := 
      c\ a . y /; vector[y] || matrix[y] || NumberQ[c]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_\  . {c_\ y_} := 
      c\ a . {y} /; vector[y] || matrix[y] || NumberQ[c]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(x_\  . x_ := Norm[x]\^2 /; vector[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(f_[x_]\  . \ f_[x_]\  := \ 
      Norm[f[x]]\^2\  /; \ Head[f] == Symbol\  && vector[f[x]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(Derivative[s_]\)[f_]\)[x_]\  . \ \(\(Derivative[s_]\)[f_]\)[
          x_]\  := \ Norm[\(\(Derivative[s]\)[f]\)[x]\ ]\^2 /; \ 
        Head[f]\  == \ Symbol\  && vector[f[x]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Partial\_j_[f_]\)[x_]\  . \ \(Partial\_j_[f_]\)[x_]\  := \ 
      Norm[\ \(Partial\_j[f]\)[x]]\^2 /; \ 
        Head[f]\  == \ Symbol\  && vector[f[x]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Delta[j_] . Delta[k_] := Delta[j, k]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Delta[j_] . x_Symbol := \((makeVector[x]; x\_j)\) /; 
        matrix[x] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_Symbol . Delta[j_] := \((makeVector[a]; a\_j)\) /; 
        matrix[a] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Delta[j_] . 
        f_Symbol[x_] := \(\((makeVector[f[_]]; \(f[x]\)[j])\) /; 
          matrix[f[x]] =!= True\) /; f =!= List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(b_Symbol[x_] . 
        Delta[j_] := \(\((makeVector[b[_]]; \(b[x]\)[j])\) /; 
          matrix[b[x]] =!= True\) /; b =!= List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Delta[j_] . \(Grad[u_]\)[x_] := \(Partial\_{j}[u]\)[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(J[b_]\)[x_] . Delta[j_] := \(Partial\_{j}[b]\)[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Delta[j_] . \(J[b_]\)[x_] := \(Grad[b . Delta[j]]\)[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Delta[j_] . Y_?matrix := Y\_\(j, "\<.\>"\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(A_?matrix . Delta[j_] := A\_\("\<.\>", j\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Delta[k_] . Y\_\(j_, "\<.\>"\) := Y\_\(j, k\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(A\_\(j_, "\<.\>"\)\  . Delta[k_] := A\_\(j, k\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Delta[j_] . Y\_\("\<.\>", k_\) := Y\_\(j, k\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(A\_\("\<.\>", k_\)\  . Delta[j_] := A\_\(j, k\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_?VectorQ . Delta[j_] := 
      a\[LeftDoubleBracket]j\[RightDoubleBracket]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Delta[j_] . v_?VectorQ := 
      v\[LeftDoubleBracket]j\[RightDoubleBracket]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A_?MatrixQ . Delta[j_] := \(Transpose[A]\)\[LeftDoubleBracket]
        j\[RightDoubleBracket]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Delta[j_] . Y_?MatrixQ := 
      A\[LeftDoubleBracket]j\[RightDoubleBracket]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(x_\  . A_?identityMatrixMultiple := 
      A\[LeftDoubleBracket]1, 1\[RightDoubleBracket]\ x /; 
        primitiveVector[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(A_?identityMatrixMultiple . x_ := 
      A\[LeftDoubleBracket]1, 1\[RightDoubleBracket]\ x /; 
        primitiveVector[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(identityMatrixMultiple[A_] := 
      MatrixQ[A] && Length[A] > 1 && 
        Length[A] === Length[A\[LeftDoubleBracket]1\[RightDoubleBracket]] && 
        And @@ \(\((A\[LeftDoubleBracket]#1, #1\[RightDoubleBracket] === 
                  A\[LeftDoubleBracket]1, 1\[RightDoubleBracket] &)\) /@ 
            Range[Length[A]]\) && 
        And @@ Flatten[
            Table[A\[LeftDoubleBracket]m, n\[RightDoubleBracket] === 0 || 
                m === n, {m, Length[A]}, {n, Length[A]}]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(a_List . 
        x_Symbol := \((makeVector[x]; a . Table[x\_j, {j, Length[a]}])\) /; 
        matrix[x] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(x_Symbol . 
        y_List := \((makeVector[x]; Table[x\_j, {j, Length[y]}] . y)\) /; 
        matrix[x] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_List . B_Symbol := 
      a . Table[\ 
            B\_\(j, k\), \ {j, \ \(Dimension[
                  B]\)[\([1]\)]}, \ {k, \ \ \(Dimension[B]\)[\([2]\)]}] /; 
        matrix[B]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(B_Symbol . c_List := 
      Table[\ B\_\(j, k\), \ {j, \ \(Dimension[
                  B]\)[\([1]\)]}, \ {k, \ \ \(Dimension[B]\)[\([2]\)]}] . c /; 
        matrix[B]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(x_?primitiveVector . y_?primitiveVector := 
      y . x /; Order[ToString[y], ToString[x]] == 1 && matrix[y] =!= True && 
          matrix[x] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(primitiveVector[x_Symbol] := 
      True /; Context[x] =!= "\<System`\>"\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(primitiveVector[\(Grad[_]\)[_]] = True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(primitiveVector[Delta[_]] = True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(degree\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(degree[f_, z_] := 
      degree1[Expand[f /. Norm[z] \[Rule] z\_normReplacement], z]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(degree1[0, _] := \(-\[Infinity]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(degree1[HoldPattern[\(+a__\)], z_] := 
      Max[Thread[degree1[{a}, z]]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(degree1[f_, z_] := Exponent[f /. z\__ \[Rule] z, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(monomialQ\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(uninomialQ[f_, \ x_Symbol]\  := \ 
      MatchQ[f, x\__]\  || \ 
        MatchQ[f, \ 
          x\__\^_?\((\((IntegerQ[#1]\  && Positive[#1])\) &)\)]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(monomialQ[f_, \ x_Symbol]\  := \ 
      uninomialQ[f, 
          x]\  || \ \((Head[f]\  === \ 
              Times\  && \ \((And @@ \(\((uninomialQ[
                        f\[LeftDoubleBracket]#1\[RightDoubleBracket], 
                        x] &)\) /@ Range[Length[f]]\))\))\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(polynomialDecomposition\ and\ blockPolynomialDecomposition\)], "Section",\

  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(polynomialDecomposition[0, x_] := Null\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(polynomialDecomposition[p_, x_] := 
      With[{p1 = Expand[p /. Norm[x] \[Rule] x\_normReplacement]}, 
          With[{t = \(({#1, degree[#1, x]} &)\) /@ 
                  If[Head[p1] === Plus, List @@ p1, {p1}]}, 
            With[{s = 
                  Table[If[
                      MemberQ[
                        t, {_, 
                          j}], {Plus @@ \(Transpose[
                              Cases[t, {_, 
                                  j}]]\)\[LeftDoubleBracket]1\
\[RightDoubleBracket], j}, Null], {j, 0, 
                      Max[\(Transpose[
                            t]\)\[LeftDoubleBracket]2\[RightDoubleBracket]]}]}\
, Delete[s, Position[s, Null]]]]] /. 
        x\_normReplacement \[Rule] Norm[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(exponentsMod2[t_, x_]\  := 
      Drop[Mod[\(Cases[
              t\ \ \((Times\  @@ \ Array[x, \ Dimension[x] + 1])\)\^2, \ 
              Power[Subscript[x, _], _]]\)[\([All, 2]\)], 
          2], \ \(-1\)]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(block[p_, \ x_, \ ex_]\  := \ 
      Select[p, \ \((exponentsMod2[#, x]\  \[Equal] \ ex)\)\  &]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(blocks[{p_, \ m_}, \ 
        x_]\  := \ {{p, \ m, \ Array[0, \ Dimension[x]]}}\  /; \ 
        m\  \[Equal] \ 0\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(blocks[{p_, \ m_}, \ x_]\  := \ {{p, \ m, \ exponentsMod2[p, x]}}\  /; 
        Not[\ Head[p]\  === \ Plus]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(blocks[{p_, \ m_}, \ x_]\  := \ 
      Module[{q = p, \ b\  = \ {}, \ ex, \ bq}, 
        While[Head[q] === Plus, ex\  = \ exponentsMod2[q[\([1]\)], \ x]; \ 
          bq\  = \ block[q, \ x, \ ex]; \ AppendTo[b, \ {bq, m, ex}]; \ 
          q\  = \ q\  - \ bq]; 
        If[q === 0, b, \ 
          Append[b, \ {q, \ m, \ exponentsMod2[q, x]}]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(blockPolynomialDecomposition[p_, \ x_]\  := \[IndentingNewLine]\ 
      Flatten[\(blocks[#, \ x] &\)\  /@ \ polynomialDecomposition[p, x], 
        1]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Delta\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(vector[Delta[_]] ^:= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Delta[j_, k_] := 0 /; j \[NotEqual] k\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Delta[j_, k_] := 1 /; j == k\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Delta[j_]\)[k_] := Delta[j, k]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Norm[Delta[_]] ^= 1;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partial\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_, {x_\__, 0}] := \((makeVector[x]; f)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_, {y_Symbol, 0}] := \((unmakeVector[y]; f)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_, {z_, n_Integer}] := 
      Module[{g\  = \ f}, \ Do[g\  = \ Together[Partial[g, z]], {n}]; g] /; 
        Positive[n]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_, z1_, z__] := 
      Module[{g\  = Partial[f, z1]}, \ 
        Do[g\  = \ Partial[g, \ {z}[\([j]\)]], \ {j, \ Length[{z}]}]; \ 
        g]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_, x_\__] := \((makeVector[x]; 0)\) /; FreeQ[f, x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_, y_Symbol] := \((unmakeVector[y]; 
        0 /; FreeQ[f, y])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[x_\_j_, x_\_k_] := \((makeVector[x]; Delta[j, k])\)\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[y_, y_] := 1\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[x_, x_\_j_] := \((makeVector[x]; Delta[j])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[HoldPattern[\(+a__\)], y_] := 
      Plus @@ Thread[Partial[{a}, y]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_\ g_, y_] := f\ Partial[g, y] + Partial[f, y]\ g\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_\  . g_, y_] := \((If[TrueQ[matrix[f]], Null, makeVector[f]]; 
        If[TrueQ[matrix[g]], Null, makeVector[g]]; 
        f . Partial[g, y] + Partial[f, y] . g)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial[f_[v_List], t_] := 
      Plus @@ \(\((\(Partial\_{#1}[f]\)[v]\ *\ 
                Partial[v\[LeftDoubleBracket]#1\[RightDoubleBracket], 
                  t] &)\) /@ Range[Length[v]]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Partial[f_\^p_, y_] := 
      p\ f\^\(p - 1\)\ Partial[f, y] + f\^p\ Log[f]\ Partial[p, y]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(Partial[f_[g_], x_\_j_]\), ":=", 
      RowBox[{"(", 
        RowBox[{\(makeVector[x]\), ";", 
          RowBox[{"If", "[", 
            
            RowBox[{\(TrueQ[vector[g]]\), 
              ",", \(If[
                TrueQ[vector[f[g]]], \(J[f]\)[g] . 
                  Partial[g, x\_j], \(Grad[f]\)[g] . Partial[g, x\_j]]\), ",",
               
              RowBox[{
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "g", "]"}], 
                " ", \(Partial[g, x\_j]\)}]}], "]"}]}], ")"}]}]], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(Partial[f_[g_], y_Symbol]\), ":=", 
      RowBox[{"(", 
        RowBox[{\(unmakeVector[y]\), ";", 
          RowBox[{"If", "[", 
            
            RowBox[{\(TrueQ[vector[g]]\), 
              ",", \(If[
                TrueQ[vector[f[g]]], \(J[f]\)[g] . 
                  Partial[g, y], \(Grad[f]\)[g] . Partial[g, y]]\), ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "g", "]"}], 
                " ", \(Partial[g, y]\)}]}], "]"}]}], ")"}]}]], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Partial\_j_List[Partial\_k_List[f_]] := 
      Partial\_\(Sort[Join[k, j]]\)[f]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NormalD\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(NormalD[f_, z_Symbol] := Grad[f, z] . z /. Norm[z] \[Rule] 1\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(NormalD[f_, v_List] := \((unmakeVector[v]; 
        Together[Grad[f, v] . v] /. Norm[v]\^2 \[Rule] 1)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Grad\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[f_, x_Symbol] := \((makeVector[x]; 0)\) /; FreeQ[f, x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[x_\_j_, x_Symbol] := \((makeVector[x]; Delta[j])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[HoldPattern[\(+a__\)], x_Symbol] := 
      Plus @@ Thread[Grad[{a}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[f_\ g_, x_Symbol] := f\ Grad[g, x] + Grad[f, x]\ g\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[f_\  . g_, x_Symbol] := f . J[g, x] + g . J[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[f_\^p_, x_Symbol] := 
      p\ f\^\(p - 1\)\ Grad[f, x] + f\^p\ Log[f]\ Grad[p, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(Grad[f_[y_], x_Symbol]\), ":=", 
      RowBox[{"(", 
        RowBox[{\(makeVector[x]\), ";", 
          RowBox[{"If", "[", 
            
            RowBox[{\(TrueQ[vector[y]]\), ",", \(\(Grad[f]\)[y] . J[y, x]\), 
              ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "y", "]"}], 
                " ", \(Grad[y, x]\)}]}], "]"}]}], ")"}]}]], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[Norm] := #1\/Norm[#1] &\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[Dimension] := 0 &\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Grad[f_, 
        v_List] := \((unmakeVector[v]; \((Partial[f, #1] &)\) /@ 
          v)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Divergence\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[f_, x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[x_, x_Symbol] := \((makeVector[x]; 
        Dimension[x])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[HoldPattern[\(+a__\)], x_Symbol] := 
      Plus @@ Thread[Divergence[{a}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[f_\ g_, x_Symbol] := 
      f\ Divergence[g, x] + Grad[f, x] . g /; \((makeVector[x]; 
          vector[g])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[A_?matrix . f_, x_Symbol] := 
      Tr[A . J[f, x]] /; FreeQ[A, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[f_\  . T_?matrix, x_Symbol] := 
      Tr[Transpose[T] . J[f, x]] /; FreeQ[T, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Divergence[u_List, v_List] := \((unmakeVector[v]; 
        Plus @@ Thread[partial[u, v]] /. 
          partial \[Rule] Partial)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(J\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[f_, x_Symbol] := \((makeVector[f]; makeVector[x]; 0)\) /; 
        FreeQ[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[x_, x_Symbol] := \((makeVector[x]; 
        IdentityMatrix[Dimension[x]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[HoldPattern[\(+a__\)], x_Symbol] := 
      Plus @@ Thread[J[{a}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[f_\ g_?vector, x_Symbol] := 
      f\ J[g, x] + Transpose[{Grad[f, x]}] . {g}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[f_Symbol[x_], 
        x_Symbol] := \((makeVector[x]; makeVector[f[_]]; \(J[f]\)[x])\) /; 
        f =!= List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(J[f_[y_], x_Symbol]\), ":=", 
      RowBox[{"If", "[", 
        RowBox[{\(TrueQ[vector[y]]\), ",", \(\(J[f]\)[y] . J[y, x]\), ",", 
          RowBox[{
            RowBox[{"Transpose", "[", 
              RowBox[{"{", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "y", "]"}], "}"}], "]"}], 
            ".", \({Grad[y, x]}\)}]}], "]"}]}]], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[A_?matrix . f_, x_Symbol] := \((makeVector[f]; A . J[f, x])\) /; 
        FreeQ[A, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[f_\  . T_?matrix, 
        x_Symbol] := \((makeVector[f]; Transpose[T] . J[f, x])\) /; 
        FreeQ[T, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(J[f_List, v_List] := \((unmakeVector[v]; 
        Table[Partial[f\[LeftDoubleBracket]m\[RightDoubleBracket], 
            v\[LeftDoubleBracket]n\[RightDoubleBracket]], {m, Length[f]}, {n, 
            Length[v]}])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(HilbertSchmidt\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(HilbertSchmidt[A_?MatrixQ] := Plus @@ \(Plus @@ \(A\^2\)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Laplacian\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[f_, v_List] := \((unmakeVector[v]; 
        Plus @@ \(\((Partial[f, {#1, 2}] &)\) /@ v\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[f_, x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[x_\_j_, x_Symbol] := \((makeVector[x]; 0)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[HoldPattern[\(+a__\)], x_Symbol] := 
      Plus @@ Thread[Laplacian[{a}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[f_\ g_, x_Symbol] := 
      f\ Laplacian[g, x] + Laplacian[f, x]\ g + 
        2\ Grad[f, x] . Grad[g, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[f_\^p_, x_Symbol] := 
      p\ f\^\(p - 1\)\ Laplacian[f, x] + 
        p\ \((p - 1)\)\ f\^\(p - 2\)\ Grad[f, x]\  . \ Grad[f, x]\  + 
        2\ p\ f\^\(p - 1\)\ Log[f]\ Grad[f, x] . Grad[p, x] + 
        f\^p\ Log[f]\ Laplacian[p, x] + 
        2\ f\^\(p - 1\)\ Grad[f, x] . Grad[p, x] + 
        f\^p\ Log[f]\^2\ Grad[p, x]\  . \ Grad[p, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[f_[a_. \ x_ + b_. ], 
        x_Symbol] := \((makeVector[x]; If[b == 0, Null, makeVector[b]]; 
          a\^2\ \(Laplacian[f]\)[a\ x + b])\) /; 
        FreeQ[a, x] && FreeQ[b, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[a_\  . x_, x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[a, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[x_\  . y_, x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[y, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[\((A_\  . x_)\) . y_, x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[A, x] && FreeQ[y, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[\((x_\  . Y_)\) . z_, x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[Y, x] && FreeQ[z, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[a_\  . \((B_\  . x_)\), x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[a, x] && FreeQ[B, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[a_\  . \((x_\  . Y_)\), x_Symbol] := \((makeVector[x]; 0)\) /; 
        FreeQ[a, x] && FreeQ[Y, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[\((A_\  . x_)\) . x_, 
        x_Symbol] := \((makeVector[x]; 2\ Tr[A])\) /; FreeQ[A, x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Laplacian[\((x_\  . A_)\) . x_, 
        x_Symbol] := \((makeVector[x]; 2\ Tr[A])\) /; FreeQ[A, x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Laplacian[x_\  . \((A_\  . x_)\), 
        x_Symbol] := \((makeVector[x]; 2\ Tr[A])\) /; FreeQ[A, x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Laplacian[x_\  . \((x_\  . A_)\), 
        x_Symbol] := \((makeVector[x]; 2\ Tr[A])\) /; FreeQ[A, x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Laplacian[b_\  . \(Grad[u_]\)[b_], b_Symbol] := \((makeVector[b]; 
        2\ Laplacian[u[b], b] + b . Grad[Laplacian[u[b], b], b])\)\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[\(Grad[u_]\)[x_] . x_, x_Symbol] := \((makeVector[x]; 
        2\ Laplacian[u[x], x] + x . Grad[Laplacian[u[x], x], x])\)\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(Laplacian[f_[g_], x_Symbol]\), ":=", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["f", "\[DoublePrime]",
                MultilineFunction->None], "[", "g", "]"}], 
            "  ", \(Grad[g, x]\  . \ Grad[g, x]\)}], " ", "+", " ", 
          RowBox[{
            RowBox[{
              SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "g", "]"}], 
            " ", \(Laplacian[g, x]\)}]}], 
        "/;", \((makeVector[x]; vector[g] =!= True)\)}]}]], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[Norm] := \(Dimension[#1] - 1\)\/Norm[#1] &\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[Norm[A_\  . x_], 
        x_] := \((makeVector[
            x]; \(Norm[A . x]\^2\ HilbertSchmidt[A]\^2 - Norm[A . x . A]\^2\)\
\/Norm[A . x]\^3)\) /; FreeQ[A, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[Norm[x_\  . Z_], 
        x_] := \((makeVector[
            x]; \(Norm[x . Z]\^2\ HilbertSchmidt[Z]\^2 - Norm[x . Z . \
Transpose[Z]]\^2\)\/Norm[x . Z]\^3)\) /; FreeQ[Z, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[Dimension] := 0 &\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[f_, x_Symbol, y_Symbol] := \((unmakeVector[y]; 
        Laplacian[f, x] + Partial[f, {y, 2}])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Laplacian\^n_\)[f_, 
        x___] := \(Laplacian\^\(n - 1\)\)[Laplacian[f, x], x] /; 
        Head[n] == Integer && Positive[n]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Laplacian[\(Laplacian\^n_. \)[f_]] := \(Laplacian\^\(n + 1\)\)[
        f]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Laplacian\^m_. \)[\(Laplacian\^n_. \)[
          u_]] := \(Laplacian\^\(m + n\)\)[u]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimension\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension[a_\ x_] := Dimension[x] /; vector[x] || matrix[x]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension[a_?NumberQ\ x_] := \((If[matrix[x] =!= True, makeVector[x]]; 
        Dimension[x])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension[a_. \ S + x_] := Dimension[x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension[x_ + w_] := 
      If[StringLength[ToString[Dimension[x]]] < 
          StringLength[ToString[Dimension[w]]], Dimension[x], 
        Dimension[w]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension[v_?VectorQ] := Length[v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dimension[A_?MatrixQ] := {Length[A], 
        Length[A\[LeftDoubleBracket]1\[RightDoubleBracket]]}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegerQ[Dimension[_]] ^:= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDimension\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SetDimension::Matrix\  = \ "\<`1` will be considered to be a matrix of \
size `2`-by-`3`.\>"\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(SetDimension[x_Symbol, {m_, n_}] := \((Dimension[x] = {m, n}; 
        makeMatrix[x]; 
        If[Not[IntegerQ[m]], Unprotect[IntegerQ]; IntegerQ[m] = True]; 
        If[Not[IntegerQ[n]], Unprotect[IntegerQ]; 
          IntegerQ[n] = 
            True]; \n\t\t\tWith[{messageOptions\  = \ \(Options[$FrontEnd, \ 
                  MessageOptions]\)[\([1]\)]}, \ 
          SetOptions[$FrontEnd, \ 
            MessageOptions \[Rule] {Global`WarningAction \[Rule] {}}]; 
          Message[SetDimension::Matrix, \ x, \ m, \ n]; \ 
          SetOptions[$FrontEnd, \ messageOptions];])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SetDimension::Vector\  = \ "\<`1` will be considered to be a vector in \
`2`-dimensional real Euclidean space.\>"\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(setDimension[x_Symbol, n_] := \((Dimension[x] = n; makeVector[x]; 
        If[Not[IntegerQ[n]], Unprotect[IntegerQ]; 
          IntegerQ[n] = True];)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SetDimension[x_Symbol, n_] := \((setDimension[x, \ n]; 
        With[{messageOptions\  = \ \(Options[$FrontEnd, \ 
                  MessageOptions]\)[\([1]\)]}, \ 
          SetOptions[$FrontEnd, \ 
            MessageOptions \[Rule] {Global`WarningAction \[Rule] {}}]; 
          Message[SetDimension::Vector, \ x, \ n]; \ 
          SetOptions[$FrontEnd, \ messageOptions];])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SetDimension::VectorValuedFunction\  = \ "\<`1` will be considered to \
be a function taking values in `2`-dimensional Euclidean space.\>"\)], "Input",\

  InitializationCell->True],

Cell[BoxData[
    \(SetDimension[f_Symbol[_], 
        n_] := \((Dimension[f[_]] = n; makeVector[f[_]]; 
          If[Not[IntegerQ[n]], Unprotect[IntegerQ]; 
            IntegerQ[n] = 
              True]; \n\t\tWith[{messageOptions\  = \ \(Options[$FrontEnd, \ 
                    MessageOptions]\)[\([1]\)]}, \ 
            SetOptions[$FrontEnd, \ 
              MessageOptions \[Rule] {Global`WarningAction \[Rule] {}}]; 
            Message[SetDimension::VectorValuedFunction, \ f, \ n]; \ 
            SetOptions[$FrontEnd, \ messageOptions];])\) /; 
        f =!= List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Homogeneous\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, x_Symbol, 
        c_Symbol] := \((makeVector[x]; makeVector[c]; 
          setDimension[c, Dimension[x]]; 
          Homogeneous[f, d, Union[Cases[Level[f, \(-1\)], x\__]], 
              Union[Cases[Level[f, \(-1\)], x\__]] /. x \[Rule] c] /. 
            Table[\ c\_j, \ {j, \ 
                  Length[Union[Cases[Level[f, \(-1\)], x\__]]]}] \[Rule] 
              c)\) /; \(! \((MemberQ[Level[f, {\(-1\)}], x])\)\) && 
          Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, x_Symbol, 
        c_Symbol] := \((makeVector[x]; makeVector[c]; 
          setDimension[c, Dimension[x]]; 
          Homogeneous[f, d, x, Table[c\_j, \ {j, \ Dimension[x]}]] /. 
            Table[c\_j, \ {j, \ Dimension[x]}] \[Rule] c)\) /; 
        MemberQ[Level[f, {\(-1\)}], x] && Head[Dimension[x]] == Integer && 
          Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, x_Symbol, 
        c_List] := \((makeVector[x]; unmakeVector[c]; 
          Module[{z}, \(\(Homogeneous[f, d, Table[x\_j, \ {j, Length[c]}], 
                    c] /. x\_j_ \[Rule] z\_j\) /. x \[Rule] c\) /. 
              z\_j_ \[Rule] x\_j])\) /; Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, v_List, 
        c_Symbol] := \((makeVector[c]; unmakeVector[v]; 
          setDimension[c, Length[v]]; 
          Homogeneous[f, d, v, Table[c\_j, \ {j, \ Dimension[c]}]])\) /; 
        Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, v_List, 
        c_List] := \((unmakeVector[v]; unmakeVector[c]; 
          If[togetherness && \(! \((Norm[c] === 0)\)\), 
            TurnOff[Togetherness]]; 
          With[{mI = multiIndices[d, Length[v]]}, 
            Plus @@ \(\((\((\((Partial @@ 
                                Prepend[
                                  Transpose[{v, 
                                      mI\[LeftDoubleBracket]#1\
\[RightDoubleBracket]}], f] /. 
                              Thread[
                                v \[Rule] 
                                  c])\)\ Times @@ \(\((v - 
                                    c)\)\^mI\[LeftDoubleBracket]#1\
\[RightDoubleBracket]\))\)/
                      multiFactorial[
                        mI\[LeftDoubleBracket]#1\[RightDoubleBracket]] &)\) /@ 
                Range[Length[mI]]\)])\) /; Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, v_List] := 
      Homogeneous[f, d, v, Table[0, {Length[v]}]] /; 
        Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, 
        x_Symbol] := \((Homogeneous[f, d, 
              Union[Cases[Level[f, \(-1\)], x\__]]] /. 
            Table[0, {Length[Union[Cases[Level[f, \(-1\)], x\__]]]}] \[Rule] 
              0)\) /; \(! \((MemberQ[Level[f, {\(-1\)}], x])\)\) && 
          Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Homogeneous[f_, d_, 
        x_Symbol] := \((Homogeneous[f, d, x, Table[0, {Dimension[x]}]] /. 
            Table[0, {Dimension[x]}] \[Rule] 0)\) /; 
        MemberQ[Level[f, {\(-1\)}], x] && Head[Dimension[x]] == Integer && 
          Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(multiIndices\ and\ multiFactorial\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiFactorial[a_List] := Times @@ \((\(a!\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiIndices[k_, 1] := {{k}}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiIndices[0, n_] := {Table[0, {n}]}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiIndices[k_, n_] := \(multiIndices[k, n] = 
        Join @@ Table[\((Prepend[#1, k - j] &)\) /@ 
              multiIndices[j, n - 1], {j, 0, k}]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiIndices[k_, 1, \ {t_}] := 
      If[Mod[k - t, 2] \[Equal] 0, {{k}}, {}]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiIndices[0, n_, \ tt_] := 
      If[And\  @@ \ EvenQ[tt], {Table[0, {n}]}, {}]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(multiIndices[k_, n_, \ tt_] := \(multiIndices[k, n, \ tt] = 
        Join @@ Table[\((Prepend[#1, k - j] &)\) /@ 
              multiIndices[j, n - 1, \ Delete[tt, 1]], {j, 
              Mod[k - tt[\([1]\)], 2], k, \ 2}]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Taylor\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Taylor[f_, d_, vc___] := 
      Plus @@ \(\((Homogeneous[f, #1, vc] &)\) /@ Range[0, d]\) /; 
        Head[d] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Volume\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Volume[n_Integer] := \[Pi]\^\(n/2\)\/Gamma[n\/2 + 1] /; 
        Positive[n]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SurfaceArea\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(SurfaceArea[n_Integer] := \(2\ \[Pi]\^\(n/2\)\)\/Gamma[n\/2] /; 
        Positive[n]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegrateBall\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateBall[f_, v_List] := \((unmakeVector[v]; 
        Module[{z}, setDimension[z, Length[v]]; 
          IntegrateBall[
            f /. Thread[v \[Rule] Table[z\_j, \ {j, \ Length[v]}]], 
            z]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateBall[f_, 
        x_Symbol] := \((makeVector[x]; \n\t\tf\ Volume[Dimension[x]])\) /; 
        FreeQ[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateBall[f_, 
        x_Symbol] := \[Integral]\_\(-1\)\%1\((f /. {Norm[x]\^2 \[Rule] x\^2, 
                  Norm[x] \[Rule] Abs[x], 
                  x\_1 \[Rule] x})\) \[DifferentialD]x /; 
        Dimension[x] == 1\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateBall[f_, x_Symbol] := \((makeVector[x]; 
        Module[{r}, 
          If[Head[Dimension[x]] === Integer, Null, 
            Limit[c_. \ r\^\(Dimension[x] + m_. \), r \[Rule] 0] := 
              0 /; \((m > 0 || m == 0)\) && FreeQ[c, r]]; 
          Dimension[x]\ Volume[
              Dimension[
                x]]\ \(\[Integral]\_0\%1 Expand[
                  r\^\(Dimension[x] - 1\)\ IntegrateSphere[
                      f /. {Norm[x] \[Rule] r, x\_j_ \[Rule] r\ x\_j, 
                          x \[Rule] r\ x}, 
                      x]] \[DifferentialD]r\)])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegrateSphere\)], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateSphere[f_, v_List] := \((unmakeVector[v]; 
        Module[{z}, setDimension[z, Length[v]]; 
          IntegrateSphere[
            f /. Thread[v \[Rule] Table[\ z\_j, \ {j, Length[v]}]], 
            z]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(IntegrateSphere[f_, x_Symbol] := \((makeVector[x]; 
        integrateSphere1[
          Expand[f /. {Norm[x] \[Rule] 1, 
                x . z_ \[RuleDelayed] 
                  Table[x\_j, {j, \ Dimension[x]}] . 
                    Table[z\_j, {j, \ Dimension[x]}], 
                z_\  . x \[RuleDelayed] 
                  Table[z\_j, {j, \ Dimension[x]}] . 
                    Table[x\_j, {j, \ Dimension[x]}]}], x])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere1[HoldPattern[\(+a__\)], x_] := 
      Plus @@ Thread[integrateSphere1[{a}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere1[f_, x_] := f /; FreeQ[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere1[c_. \ x_\__, x_] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere1[c_\ f_, x_] := 
      c\ integrateSphere1[f, x] /; FreeQ[c, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere1[x_\__\^j_, x_] := 
      integrateSphere3[{j}, Dimension[x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere1[f_, x_] := 
      integrateSphere2[f, x] /; monomialSpecialQ[f, x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere2[f_, x_] := 
      integrateSphere3[List @@ f /. x\__\^b_ \[Rule] b, 
        Dimension[x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere3[b_, n_] := 0 /; Or @@ OddQ[b]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(integrateSphere3[b_, n_] := 
      Times @@ \((\(\((b - 1)\)!!\))\)\/Times @@ Range[n, n + Plus @@ b - 2, \
2]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(monomialSpecialQ[f_, x_Symbol] := 
      Head[f] === Times && 
        And @@ \(\((MatchQ[f\[LeftDoubleBracket]#1\[RightDoubleBracket], 
                  x\__\^_] &)\) /@ Range[Length[f]]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Boundary\ Value\ Problems\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Dirichlet", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Options[Dirichlet] = {Region \[Rule] Sphere, \ 
        Laplacian \[Rule] 0}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Dirichlet[p_, \ x_Symbol, options__]\  := \ 
      With[\ {t\  = \ 
              AntiLaplacian[\((\(Laplacian\  /. \ {options}\)\  /. \ 
                    Options[Dirichlet])\), x, \ Singularity\  \[Rule] \ 0]}, 
          Factor[t + 
              Dirichlet[p - t, x, \ 
                Sequence\  @@ \ 
                  DeleteCases[{options}, \ Laplacian \[Rule] _]]]] /; \ 
        And[\((\(Region\  /. \ {options}\)\  /. \ 
                Options[Dirichlet])\)\  === \ ExteriorSphere, \ 
          MemberQ[{options}, \ Laplacian \[Rule] \ _]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Dirichlet[p_, \ x_Symbol, options__]\  := \ 
      With[\ {t\  = \ 
              AntiLaplacian[\((\(Laplacian\  /. \ {options}\)\  /. \ 
                    Options[Dirichlet])\), x]}, \ 
          t + Dirichlet[p - t, x, \ 
              Sequence\  @@ \ 
                DeleteCases[{options}, \ Laplacian \[Rule] _]]]\  /; \ 
        MemberQ[{options}, \ Laplacian \[Rule] \ _]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Dirichlet[p_, \ x_Symbol, options___]\  := \ 
      With[\ {region\  = \ \((\(Region\  /. \ {options}\)\  /. \ 
                Options[Dirichlet])\)}, \ 
        Which[region\  === \ Sphere, \ 
          dirichlet[p, x], \[IndentingNewLine]Head[region] === Quadratic, \ 
          p\  + \ AntiLaplacian[\(-Laplacian[p, x]\), \ x, \ 
              Multiple \[Rule] \ region], \[IndentingNewLine]region\  === \ 
            ExteriorSphere, \ 
          exteriorDirichlet[p, x], \[IndentingNewLine]Head[region]\  === \ 
            Annulus, \ 
          If[Head[p] === List, \ 
            annularDirichlet[p[\([1]\)], p[\([2]\)], region[\([1]\)], \ 
              region[\([2]\)], x], \ 
            annularDirichlet[p, p, region[\([1]\)], \ region[\([2]\)], 
              x]]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(dirichlet[p_, x_] := 
      Plus @@ \(\((#1\[LeftDoubleBracket]1\[RightDoubleBracket] &)\) /@ 
            HarmonicDecomposition[p /. Norm[x] \[Rule] 1, x]\)\  /; \ 
        PolynomialQ[p\  /. \ Norm[x] \[Rule] 1, \ 
          Cases[p, \ x\__, \[Infinity]]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(Dirichlet[f_, v_List, \ opt___]\)\(:=\)\(explicit[Dirichlet, f, 
        v, \ opt]\)\(\ \)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(exteriorDirichlet[f_, z_] := 
      Factor[Kelvin[Dirichlet[f, z], z]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(annular[0, r_, s_, z_] = 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(annular[f_, r_, s_, z_] := 
      Plus @@ \(\((If[#1\[LeftDoubleBracket]2\[RightDoubleBracket] === #1\
\[LeftDoubleBracket]3\[RightDoubleBracket], \(\((Log[Norm[z]] - Log[s])\)\ \
r\^#1\[LeftDoubleBracket]2\[RightDoubleBracket]\ #1\[LeftDoubleBracket]1\
\[RightDoubleBracket]\)\/\(Log[r] - Log[s]\), \(\((Norm[z]\^\(2\ #1\
\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\
\[RightDoubleBracket]\) - s\^\(2\ \
#1\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\
\[RightDoubleBracket]\))\)\ r\^#1\[LeftDoubleBracket]2\[RightDoubleBracket]\ \
#1\[LeftDoubleBracket]1\[RightDoubleBracket]\)\/\(r\^\(2\ #1\
\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\
\[RightDoubleBracket]\) - s\^\(2\ \
#1\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\
\[RightDoubleBracket]\)\)] &)\) /@ 
            Flatten[\((append[
                      HarmonicDecomposition[#1\[LeftDoubleBracket]1\
\[RightDoubleBracket], 
                        z], #1\[LeftDoubleBracket]2\[RightDoubleBracket]] \
&)\) /@ polynomialDecomposition[f, z], 1]\) /; Dimension[z] == 2\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(annular[f_, r_, s_, z_] := 
      Plus @@ \(\((\((\((Norm[z]\^\(2 - Dimension[z] + 2\ #1\
\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\
\[RightDoubleBracket]\) - 
                        s\^\(2 - Dimension[z] + 2\ #1\[LeftDoubleBracket]2\
\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\[RightDoubleBracket]\))\)\ \
r\^#1\[LeftDoubleBracket]2\[RightDoubleBracket]\ #1\[LeftDoubleBracket]1\
\[RightDoubleBracket])\)/\((r\^\(2 - Dimension[z] + 2\ \
#1\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\
\[RightDoubleBracket]\) - 
                    s\^\(2 - Dimension[z] + 2\ #1\[LeftDoubleBracket]2\
\[RightDoubleBracket] - 2\ #1\[LeftDoubleBracket]3\[RightDoubleBracket]\))\) \
&)\) /@ Flatten[\((append[
                    HarmonicDecomposition[#1\[LeftDoubleBracket]1\
\[RightDoubleBracket], 
                      z], #1\[LeftDoubleBracket]2\[RightDoubleBracket]] &)\) /@ 
              polynomialDecomposition[f, z], 1]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(append[b_, d_] := \((Append[#1, d] &)\) /@ b\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(annularDirichlet[f_, g_, r_, s_, z_Symbol] := 
      annular[f, r, s, z] + annular[g, s, r, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["HarmonicDecomposition", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(d[0, 0] = 1\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(lap[f_, v_] := 
      Plus @@ \(\((\[PartialD]\_{#1, 2}f &)\) /@ v\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(HarmonicDecomposition[0, x_] := {}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(HarmonicDecomposition[p_, x_Symbol] := \((makeVector[x]; 
        With[{deg = degree[p /. Norm[x] \[Rule] norm, x], n = Dimension[x]}, 
          powers = {}; hd[_] := 0; 
          With[{partition = 
                Partition[
                  Flatten[
                    Expand[\((\((m = #1\[LeftDoubleBracket]2\
\[RightDoubleBracket]; k = Floor[m\/2]; 
                                If[m > 1, 
                                  d[1, 1] = 1\/\(2\ \((2\ m + n - 4)\)\)]; 
                                v = Select[
                                    Variables[#1\[LeftDoubleBracket]1\
\[RightDoubleBracket]], \(! \((FreeQ[#1, x])\)\) &]; 
                                laplac[
                                    0] = #1\[LeftDoubleBracket]1\
\[RightDoubleBracket]; laplac[1] = 
                                  lap[#1\[LeftDoubleBracket]1\
\[RightDoubleBracket], v]; Do[d[j, 
                                      j] = \(d[j - 1, j - 1]\ \((2\ m + n - 2\
\ j)\)\)\/\(2\ j\ \((2\ m + n - 4\ j + 2)\)\ \((2\ m + n - 4\ j)\)\); 
                                  laplac[j] = lap[laplac[j - 1], v], {j, 2, 
                                    k}]; Do[
                                  d[i, j] = 
                                    d[i, j - 1]\/\(2\ \((i - j)\)\ \((2\ \((m \
- i - j - 1)\) + n)\)\), {i, 0, k - 1}, {j, i + 1, k}]; 
                                Table[{\[Sum]\+\(j = i\)\%k d[i, 
                                        j]\ Norm[x]\^\(2\ \((j - i)\)\)\ \
laplac[j], 2\ i}, {i, 0, k}])\) &)\) /@ 
                          polynomialDecomposition[p /. Norm[x] \[Rule] norm, 
                            x]] //. {a_.  + norm\^e_. \ b_. , 
                          j_} \[Rule] {{a, j}, {b, j + e}}], 2]}, 
            powers = 
              powers \[Union] \(Transpose[
                    partition]\)\[LeftDoubleBracket]2\[RightDoubleBracket]; \
\((\((hd[#1\[LeftDoubleBracket]2\[RightDoubleBracket]] = 
                      hd[#1\[LeftDoubleBracket]2\[RightDoubleBracket]] + #1\
\[LeftDoubleBracket]1\[RightDoubleBracket])\) &)\) /@ partition]; 
          aa = Select[\(({hd[#1], #1} &)\) /@ 
                powers, #1\[LeftDoubleBracket]1\[RightDoubleBracket] =!= 
                  0 &]; Clear[hd]; aa])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(HarmonicDecomposition[f_, v_List] := 
      explicit[HarmonicDecomposition, f, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["AntiLaplacian", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Options[AntiLaplacian] = {Multiple \[Rule] None, 
        Singularity \[Rule] None}\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(AntiLaplacian[0, x_, options___?OptionQ] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(AntiLaplacian[p_, x_Symbol, 
        options___?OptionQ] := \((makeVector[x]; \[IndentingNewLine]If[
          Head[\(Multiple /. {options}\) /. Options[AntiLaplacian]] === 
            Quadratic, \[IndentingNewLine]antiLaplacianQ[p, \ x, \ 
            Multiple\  /. \ {options}], \[IndentingNewLine]If[\((\(Multiple /. \
{options}\) /. Options[AntiLaplacian])\) === 
                Norm\^2 || \(! \((FreeQ[p, Norm[x]])\)\), 
            antiLaplacianN[Expand[p], x, options], 
            antiLaplacian[Expand[p], x]]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(antiLaplacianQ[p_, \ x_, \ 
        q_\ ]\  := \ \[IndentingNewLine]With[{ph\  = \ 
            blockPolynomialDecomposition[p, \ x]}, 
        If[Length[q]\  \[Equal] \ 
            1, \ \((q[\([1]\)] . Array[x, Length[q[\([1]\)]]]\^2)\) 
            Sum[antiLaplacianQ2[ph[\([j]\)], \ x, \ q[\([1]\)]], \ {j, 1, \ 
                Length[ph]}], \[IndentingNewLine]If[
            Length[q] \[Equal] 
              2, \ \((q[\([1]\)] . 
                    Array[x, Length[q[\([1]\)]]]\^2 + \ \ q[\([2]\)])\) 
              Sum[antiLaplacianQ4[ph[\([j]\)], \ x, \ List\  @@ \ q], \ {j, 
                  1, \ Length[ph]}], \((q[\([1]\)] . 
                    Array[x, Length[q[\([1]\)]]]\^2 + \ 
                  q[\([2]\)] . Array[x, Length[q[\([2]\)]]] + \ q[\([3]\)])\) 
              Sum[antiLaplacianQ3[ph[\([j]\)], \ x, \ List\  @@ \ q], \ {j, 
                  1, \ Length[ph]}]]\[IndentingNewLine]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ4[p_, \ x_, \ q_\ ]\  := \ 
      antiLaplacianQ2[p, \ x, \ q[\([1]\)]]\  /; \ 
        q[\([2]\)]\  === 0\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ4[p_, \ x_, \ q_\ ]\  := \ 
      Module[{f}, 
        With[{m\  = \ p[\([2]\)], \ q2\  = \ q[\([1]\)], \ 
            q0\  = \ q[\([2]\)], \ 
            p3 = \ p[\([3]\)]}, \[IndentingNewLine]f[m + 1]\  = \ 
            0; \[IndentingNewLine]f[m]\  = \ 
            antiLaplacianQ2[p, \ x, \ q2]; \[IndentingNewLine]Do[
            f[m - j]\  = \ \ antiLaplacianQ2[{\(-Laplacian[
                      q0\ f[m - j + 2], \ x]\), m - j, p3}, x, q2], {j, 1, 
              m}\ ]; \[IndentingNewLine]Sum[
            f[j], \ {j, 0, \ m}]\[IndentingNewLine]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ3[p_, \ x_, \ q_\ ]\  := \ 
      antiLaplacianQ4[p, \ 
          x, \ {q[\([1]\)], q[\([3]\)]}]\  /; \ \ q[\([2]\)]\  === \ 
          Array[0, Dimension[x]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ3[p_, \ x_, \ q_\ ]\  := \ 
      Module[{f}, 
        With[{m\  = \ p[\([2]\)], \ q2\  = \ q[\([1]\)], \ 
            q1\  = \ q[\([2]\)] . Array[x, Length[q[\([2]\)]]], \ 
            q0\  = \ q[\([3]\)]}, \[IndentingNewLine]f[m + 1]\  = \ 
            0; \[IndentingNewLine]f[m]\  = \ 
            antiLaplacianQ2[p, \ x, \ q2]; \[IndentingNewLine]Do[
            f[m - j]\  = \ \ antiLaplacianQ2a[\(-Laplacian[
                    q1\ f[m - j + 1]\  + \ q0\ f[m - j + 2], \ x]\), x, 
                q2], {j, 1, m}\ ]; \[IndentingNewLine]Sum[
            f[j], \ {j, 0, \ m}]\[IndentingNewLine]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ2a[0, \ x_, \ q_]\  := \ 0\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ2a[p_, \ x_, \ 
        q_\ ]\  := \ \[IndentingNewLine]With[{ph\  = \ 
            blockPolynomialDecomposition[p, \ x]}, 
        Sum[antiLaplacianQ2[ph[\([j]\)], \ x, \ q], \ {j, 1, \ 
            Length[ph]}]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ2[p_, \ x_, \ 
        q_]\  := \ \ p[\([1]\)]/\((2\ Plus\  @@ \ q)\)\  /; \ 
        p[\([2]\)]\  \[Equal] \ 0\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianQ2[p_, \ x_, \ 
        q_]\  := \ \ With[{p1 = p[\([1]\)], \ 
          twoA\  = \ 2 \((Plus\  @@ \ q)\), \ n\  = \ Dimension[x], \ 
          multiIndicesmn\  = 
            multiIndices[p[\([2]\)], Dimension[x], \ p[\([3]\)]]}, 
        Module[{d, 
            s}, \((\((Plus\  @@ \ 
                    Map[d\_#\ \((Times\  @@ \ \(Array[x, n]\^#\))\)/
                            multiFactorial[#] &, \ multiIndicesmn])\)\  /. \ 
                Solve[Map[\((Expand[\((twoA\  + \ 
                                    4\ \ Plus\  @@ \ \((#\ q)\))\)\ d\_#\  + \
\ \((\((Plus\  @@ \ \((#\ \((#\  - \ 1)\)\ q\ Table[
                                        d\_\(ReplacePart[#, \ #[\([i]\)] - 2, \
i]\), {i, \ n}])\))\) /. \ d\_\(\(s_\)\(\ \)\) :> \ 
                                    Sum[d\_\(ReplacePart[s, \ s[\([j]\)] + 2, \
j]\), {j, n}])\)]\  \[Equal] \ 
                          multiFactorial[#]\ Coefficient[p1, 
                              Times\  @@ \ \(Array[x, n]\^#\)])\) &, \ 
                    multiIndicesmn], \ 
                  Map[d\_# &, \ multiIndicesmn]])\)[\([1]\)]]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(antiLaplacianN[HoldPattern[\(+a__\)], z_, options___?OptionQ] := 
      Plus @@ Thread[Unevaluated[antiLaplacianN[{a}, z, options]]]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacianN[c_\ g_, z_, options___?OptionQ] := 
      c\ antiLaplacianN[g, z, options] /; FreeQ[c, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacianN[g_, z_, options___?OptionQ] := 
      antiLap1[If[Head[g] === Times, Select[g, FreeQ[#1, Norm[z]] &], 
          If[FreeQ[g, Norm[z]], g, 1]], 
        If[Head[g] === Times, Select[g, \(! \((FreeQ[#1, Norm[z]])\)\) &], 
          If[FreeQ[g, Norm[z]], 1, g]], z, options]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(antiLap1[p_, f_, z_, options___?OptionQ] := 
      Plus @@ \(\((antiLap2[#1\[LeftDoubleBracket]1\[RightDoubleBracket], #1\
\[LeftDoubleBracket]2\[RightDoubleBracket], f, z, options] &)\) /@ 
          HarmonicDecomposition[p, z]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(antiLap2[p_, j_, f_, z_, options___?OptionQ] := 
      Plus @@ \(\((antiLap3[#1\[LeftDoubleBracket]1\[RightDoubleBracket], #1\
\[LeftDoubleBracket]2\[RightDoubleBracket], j, f, z, options] &)\) /@ 
          polynomialDecomposition[p, z]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(antiLap3[p_, m_, j_, f_, z_, options___?OptionQ] := 
      With[{n = Dimension[z]}, 
        p\ If[\((\(Singularity /. {options}\) /. Options[AntiLaplacian])\) =!= 
                None, \[Integral]t\^\(1 - 2\ m - n\)\ \
\((\[Integral]\((t\^\(\(-1\) + 2\ m + n + j\)\ f /. 
                            Norm[z] \[Rule] 
                              t)\) \[DifferentialD]t)\) \[DifferentialD]t, 
              With[{int = \[Integral]\_0\%t\((s\^\(\(-1\) + 2\ m + n + j\)\ f \
/. Norm[z] \[Rule] 
                              s)\) \[DifferentialD]s}, \[Integral]t\^\(1 - 2\ \
m - n\)\ If[FreeQ[int, Indeterminate] && FreeQ[int, \[Infinity]] && 
                        FreeQ[int, Limit] && FreeQ[int, If] && 
                        FreeQ[int, 
                          Integrate] && \((\(Singularity /. {options}\) /. 
                              Options[AntiLaplacian])\) === None, 
                      int, \[Integral]\((t\^\(\(-1\) + 2\ m + n + j\)\ f /. 
                              Norm[z] \[Rule] 
                                t)\) \[DifferentialD]t] \[DifferentialD]t]] /. 
          t \[Rule] Norm[z]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(AntiLaplacian[f_, v_List, options___?OptionQ] := \((unmakeVector[v]; 
        Module[{z}, setDimension[z, Length[v]]; 
          AntiLaplacian[\(f /. Norm[v]\^2 \[Rule] Norm[z]\^2\) /. 
                Thread[v \[Rule] Table[z\_j, \ {j, \ Length[v]}]], z, 
              options] /. 
            Prepend[Thread[Table[z\_j, \ {j, \ Length[v]}] \[Rule] v], 
              Norm[z] \[Rule] Norm[v]]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacian[HoldPattern[\(+a__\)], z_] := 
      Plus @@ Thread[antiLaplacian[{a}, z]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacian[g_, z_] := 1\/2\ g\ z\_1\^2 /; FreeQ[g, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacian[g_, z_] := 
      antiLaplacian3[
          Transpose[
            Sort[\(({Exponent[g, 
                        z\_#1], #1} &)\) /@ \(\((#1\[LeftDoubleBracket]2\
\[RightDoubleBracket] &)\) /@ Variables[g]\)]], g, z] /; 
        monomialQ[g, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacian[c_\ g_, z_] := 
      c\ antiLaplacian[g, z] /; FreeQ[c, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacian3[{e_, p_}, g_, z_] := 
      z\_\(p\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket]\)\^\(e\
\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket] + 2\)\/\(\((e\
\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket] + 2)\)\ \((e\
\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket] + 1)\)\) /; 
        Length[e] == 1\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(antiLaplacian3[{e_, p_}, g_, 
        z_] := \(g\ z\_\(Last[p]\)\^2\)\/\(\((Last[e] + 1)\)\ \((Last[e] + 2)\
\)\) - Plus @@ \(\((\(\((e\[LeftDoubleBracket]#1\[RightDoubleBracket] - 1)\)\ \
e\[LeftDoubleBracket]#1\[RightDoubleBracket]\ \
antiLaplacian[\(z\_\(Last[p]\)\^2\ g\)\/z\_\(p\[LeftDoubleBracket]#1\
\[RightDoubleBracket]\)\^2, z]\)\/\(\((Last[e] + 1)\)\ \((Last[e] + 2)\)\) &)\
\) /@ Range[\(Position[Positive[e], True]\)\[LeftDoubleBracket]1, 
                  1\[RightDoubleBracket], Length[e] - 1]\) /; 
        Length[e] > 1\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Neumann", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Neumann[f_, v_List] := explicit[Neumann, f, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Neumann[f_, g_, v_List] := explicit[Neumann, f, g, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Neumann[0, x_Symbol] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Neumann[f_, x_Symbol] := 
      Plus @@ \(\((If[#1\[LeftDoubleBracket]2\[RightDoubleBracket] === 0, 
                0, #1\[LeftDoubleBracket]1\[RightDoubleBracket]\/#1\
\[LeftDoubleBracket]2\[RightDoubleBracket]] &)\) /@ 
          polynomialDecomposition[Dirichlet[f, x], x]\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Neumann[f_, g_, x_Symbol] := 
      With[{v = AntiLaplacian[g, x]}, 
        v + Neumann[f - NormalD[v, x], x] - 
          Limit[v /. {x\__ \[Rule] 0, Norm[x] \[Rule] t}, t \[Rule] 0, 
            Direction \[Rule] \(-1\)]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["ExteriorNeumann", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExteriorNeumann[f_, v_List] := 
      explicit[ExteriorNeumann, f, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExteriorNeumann[f_, g_, v_List] := 
      explicit[ExteriorNeumann, f, g, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExteriorNeumann[0, x_Symbol] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ExteriorNeumann[f_, x_Symbol] := 
      Plus @@ \(\((\(Norm[x]\^\(2 - Dimension[x] - 2\ #1\[LeftDoubleBracket]2\
\[RightDoubleBracket]\)\ \
#1\[LeftDoubleBracket]1\[RightDoubleBracket]\)\/\(Dimension[x] + #1\
\[LeftDoubleBracket]2\[RightDoubleBracket] - 2\) &)\) /@ 
            polynomialDecomposition[Dirichlet[f, x], x]\) /; 
        Dimension[x] =!= 2\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ExteriorNeumann[f_, x_Symbol] := 
      Plus @@ \(\((Norm[x]\^\(\(-2\)\ #1\[LeftDoubleBracket]2\
\[RightDoubleBracket]\)\ #1\[LeftDoubleBracket]1\[RightDoubleBracket]\ If[#1\
\[LeftDoubleBracket]2\[RightDoubleBracket] === 0, 0, 
                    1\/#1\[LeftDoubleBracket]2\[RightDoubleBracket]] &)\) /@ 
            polynomialDecomposition[Dirichlet[f, x], x]\) /; 
        Dimension[x] === 2\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ExteriorNeumann[f_, g_, x_Symbol] := 
      With[{v = AntiLaplacian[g, x, Singularity \[Rule] 0]}, 
        v + ExteriorNeumann[f + NormalD[v, x], x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["BiDirichlet", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BiDirichlet[f_, v_List] := explicit[BiDirichlet, f, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BiDirichlet[f_, g_, v_List] := 
      explicit[BiDirichlet, f, g, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BiDirichlet[f_, z_Symbol] := 
      Together[With[{p = Dirichlet[f, z]}, 
          p + 1\/2\ \((1 - Norm[z]\^2)\)\ z . Grad[p, z]]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BiDirichlet[f_, g_, z_Symbol] := 
      normalIntegral[Dirichlet[g, z], z] + BiDirichlet[f, z]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(normalIntegral[p_, z_] := 1\/2\ \((Norm[z]\^2 - 1)\)\ p\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Spherical\ Harmonics\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["ZonalHarmonic", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZonalHarmonic[0, x_, z_] := 1\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZonalHarmonic[m_Integer, x_Symbol, z_Symbol] := \((makeVector[x]; 
        makeVector[z]; 
        Plus @@ \(\((\(1\/\(\(#1!\)\ \(\((m - 
                              2\ #1)\)!\)\ 2\^#1\)\) \((\((\(-1\))\)\^#1\ \
\((Dimension[x + z] + 2\ m - 2)\)\ Times @@ 
                        Range[Dimension[x + z], 
                          Dimension[x + z] + 2\ m - 2\ #1 - 4, 
                          2]\ \((x . z)\)\^\(m - 2\ #1\)\ Norm[x]\^\(2\ #1\)\ \
Norm[z]\^\(2\ #1\))\) &)\) /@ Range[0, m\/2]\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(ZonalHarmonic[m_Integer, x_List, z_List] := \((unmakeVector[x]; 
        unmakeVector[z]; 
        Expand[Plus @@ \(\((\((\((\(-1\))\)\^#1\ \((Length[x] + 2\ m - 
                            2)\)\ Times @@ 
                          Range[Length[x], Length[x] + 2\ m - 2\ #1 - 4, 
                            2]\ \((x . z)\)\^\(m - 2\ #1\)\ Norm[x]\^\(2\ \
#1\)\ Norm[z]\^\(2\ #1\))\)/\((\(#1!\)\ \(\((m - 2\ #1)\)!\)\ 2\^#1)\) &)\) /@ 
              Range[0, m\/2]\)])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["DimensionH", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(DimensionH[0, 2] = 1;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(DimensionH[m_, n_] := 
      Binomial[n + m - 1, n - 1] - Binomial[n + m - 3, n - 1]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["BasisH", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Options[BasisH] = {Orthonormal \[Rule] None};\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BasisH[0, x_, options___?OptionQ] := 
      With[{orthonormal = \(Orthonormal /. {options}\) /. Options[BasisH]}, 
        If[orthonormal === None, {1}, 
          Which[orthonormal === Sphere, {1}, 
            orthonormal === Ball, {1\/\@Volume[Dimension[x]]}]]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BasisH[m_Integer, x_Symbol, options___?OptionQ] := 
      Together[With[{orthonormal = \(Orthonormal /. {options}\) /. 
                  Options[BasisH]}, 
            Module[{xx}, 
              With[{ttt = 
                    Expand[Expand[\((Kelvin[#1, 
                                  xx] &)\) /@ \(\((Partial @@ 
                                    Prepend[Transpose[{{xx\_1, xx\_2}, #1}], 
                                      Log[Norm[xx]]] &)\) /@ 
                              Join[\((Prepend[#1, 0] &)\) /@ 
                                  multiIndices[m, 1], \((Prepend[#1, 1] &)\) /@ 
                                  multiIndices[m - 1, 1]]\)]] /. 
                      xx \[Rule] x}, 
                If[orthonormal === None, 
                  noLeadingMinus /@ \(Transpose[
                        FactorTermsList /@ 
                          ttt]\)\[LeftDoubleBracket]2\[RightDoubleBracket], 
                  orthonormalize[
                    ttt, \(Which[orthonormal === Sphere, IntegrateSphere, 
                          orthonormal === Ball, IntegrateBall]\)[#1\ #2, 
                        x] &]]]]]] /; Dimension[x] == 2\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BasisH[m_Integer, x_Symbol, options___?OptionQ] := 
      Together[With[{orthonormal = \(Orthonormal /. {options}\) /. 
                  Options[BasisH]}, 
            Module[{xx}, 
              With[{ttt = 
                    Expand[Expand[\((Kelvin[#1, 
                                  xx] &)\) /@ \(\((Partial @@ 
                                    Prepend[
                                      Transpose[{Table[\ 
                                        xx\_j, \ {j, \ Dimension[x]}], #1}], 
                                      Norm[xx]^\((2 - Dimension[x])\)] &)\) /@ 
                              Join[\((Prepend[#1, 0] &)\) /@ 
                                  multiIndices[m, 
                                    Dimension[x] - 
                                      1], \((Prepend[#1, 1] &)\) /@ 
                                  multiIndices[m - 1, Dimension[x] - 1]]\)]] /. 
                      xx \[Rule] x}, 
                If[orthonormal === None, 
                  noLeadingMinus /@ \(Transpose[
                        FactorTermsList /@ 
                          ttt]\)\[LeftDoubleBracket]2\[RightDoubleBracket], 
                  orthonormalize[
                    ttt, \(Which[orthonormal === Sphere, IntegrateSphere, 
                          orthonormal === Ball, IntegrateBall]\)[#1\ #2, 
                        x] &]]]]]] /; 
        Head[Dimension[x]] == Integer\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BasisH[m_Integer, v_List, options___?OptionQ] := \((unmakeVector[v]; 
        Module[{z}, setDimension[z, Length[v]]; 
          Expand[BasisH[m, z, options] /. 
                Thread[Table[\ z\_j, \ {j, Length[v]}] \[Rule] v]] /. 
            Norm[z] \[Rule] Norm[v]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(noLeadingMinus[x_] := 
      If[Head[x] === Plus, 
        If[Head[x\[LeftDoubleBracket]1\[RightDoubleBracket]] === Times, 
          If[x\[LeftDoubleBracket]1, 1\[RightDoubleBracket] < 0, 
            Expand[\(-x\)], x, x], 
          If[x\[LeftDoubleBracket]1\[RightDoubleBracket] < 0, Expand[\(-x\)], 
            x, x]], x]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["orthonormalize", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(orthonormalize[b_List, innerProduct_] := \ 
      Module[{e, j, t}, 
        Do[e[j] = 
            b\[LeftDoubleBracket]j\[RightDoubleBracket] - 
              Plus @@ \(\((innerProduct[
                          b\[LeftDoubleBracket]j\[RightDoubleBracket], 
                          e[#1]]\ e[#1]/t[#1] &)\) /@ Range[j - 1]\); 
          t[j]\  = \ innerProduct[e[j], e[j]], {j, 1, 
            Length[b]}]; \(Together[e[#1]\/\@t[#1]] &\) /@ 
          Range[Length[b]]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(The\ Kelvin\ Transform\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Reflection", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[\[Infinity]] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_] := \((If[Head[x] == Symbol, makeVector[x]]; 
        If[Norm[x] === 0, \[Infinity], x/Norm[x]\^2])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_List, \ Sphere[r_, \ c_]] := \ 
      Reflection[x, \ 
          Sphere[r, \ Table[c . Delta[j], {j, 1, Length[x]}]]]\  /; \ 
        Head[c]\  =!= \ List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_, \ Sphere[r_, \ c_List]] := \ 
      Reflection[Table[x . Delta[j], {j, 1, Length[c]}], \ 
          Sphere[r, \ c]]\  /; \ Head[x]\  =!= \ List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_, \ Sphere[r_, \ c_]] := \ 
      c\  + \ \(r\^2\) Reflection[x - c]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_, \ Hyperplane[b_, \ c_]] := \ 
      x\  - \ \(2 \((\((x . b)\) - c)\) b\)\/Norm[b]\^2\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_List, \ Hyperplane[b_, \ c_]] := \ 
      Reflection[x, \ 
          Hyperplane[Table[b . Delta[j], {j, 1, Length[x]}], c]]\  /; \ 
        Head[b]\  =!= \ List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Reflection[x_, \ Hyperplane[b_List, c_]] := \ 
      Reflection[Table[x . Delta[j], {j, 1, Length[b]}], \ 
          Hyperplane[b, \ c]]\  /; \ Head[x]\  =!= \ List\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Kelvin", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Kelvin[HoldPattern[\(+u__\)], x_] := 
      Plus @@ Thread[Kelvin[{u}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Kelvin[u_, x_List] := \((unmakeVector[x]; 
        Norm[x]\^\(2 - Length[x]\)\ \((u /. 
              Thread[x \[Rule] Reflection[x]])\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Kelvin[u_, x_Symbol] := \((makeVector[x]; 
        Norm[x]\^\(2 - Dimension[x]\)\ \((u /. {x \[Rule] Reflection[x], 
                x\_j_ \[RuleDelayed] x\_j\/Norm[x]\^2})\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["\[CapitalPhi]", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[CapitalPhi][z_List] := \((unmakeVector[z]; 
        If[Last[z] === \(-1\) && Norm[Drop[z, \(-1\)]] === 0, \[Infinity], 
          2\ Reflection[z + Append[Table[0, {Length[z] - 1}], 1]] - 
            Append[Table[0, {Length[z] - 1}], 1]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[CapitalPhi][
        z_] := \((If[\(! \((z === 0 || z === \[Infinity] || 
                MatchQ[z, _. \ S])\)\), makeVector[z]; 
          If[Dimension[S] =!= \ Dimension[z], 
            SetDimension[S, Dimension[z]]]]; 
        2\ Reflection[z - S] + S)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(\[CapitalPhi][0, \(-1\)] = \[Infinity];\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[CapitalPhi][x_, y_] := \ \((makeVector[x]; 
        unmakeVector[
          y]; {\(2\ x\)\/\(Norm[x]\^2 + \((y + 1)\)\^2\), \(2\ \((y + \
1)\)\)\/\(Norm[x]\^2 + \((y + 1)\)\^2\) - 1})\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["S", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Norm[S] ^= 1;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(S . z_Symbol := \(-z\_\(Dimension[z]\)\) /; 
        matrix[z] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(a_Symbol . S := \(-a\_\(Dimension[a]\)\) /; 
        matrix[z] =!= True\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(makeVector[S];\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(N[S\_j_Real]\  := \ 
        S\_\(Round[j]\) /; \ Round[j]\  == \ j;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(S\_j_ := \(-1\) /; j == Dimension[S]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(S\_j_ := 0 /; j < Dimension[S]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["KelvinM", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(KelvinM[HoldPattern[\(+u__\)], x_] := 
      Plus @@ Thread[KelvinM[{u}, x]]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(KelvinM[u_, x_List] := \((unmakeVector[x]; 
        2\^\(1\/2\ \((Length[x] - 2)\)\)\ \((Norm[x]\^2 + 2\ Last[x] + 1)\)\^\
\(2 - Length[x]\)\ \((u /. 
              Thread[x \[Rule] \[CapitalPhi][x]])\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(KelvinM[u_, z_Symbol] := \((makeVector[z]; 
        2\^\(1\/2\ \((Dimension[z] - 2)\)\)\ Norm[z - S]\^\(2 - \
Dimension[z]\)\ \((u /. {z \[Rule] \[CapitalPhi][z], 
                z\_j_ \[RuleDelayed] \[CapitalPhi][z] . 
                    Delta[j]})\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(KelvinM[u_, x_Symbol, y_Symbol] := \((makeVector[x]; unmakeVector[y]; 
        2\^\(1\/2\ \((Dimension[x] - 1)\)\)\ \((Norm[x]\^2 + \((y + \
1)\)\^2)\)\^\(1\/2\ \((1 - Dimension[x])\)\)\ \((u /. {x \[Rule] \(2\ \
x\)\/\(Norm[x]\^2 + \((y + 1)\)\^2\), 
                y \[Rule] \(2\ \((y + 1)\)\)\/\(Norm[x]\^2 + \((y + 1)\)\^2\) \
- 1, x\_j_ \[RuleDelayed] \(2\ x\_j\)\/\(Norm[x]\^2 + \((y + 1)\)\^2\)})\))\)\
\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Kernels\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["PoissonKernel", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(PoissonKernel[x_, z_] := \((makeVector[x]; 
        makeVector[
          z]; \(1 - Norm[x]\^2\ Norm[z]\^2\)\/\((1 - 2\ x . z + Norm[x]\^2\ \
Norm[z]\^2)\)\^\(1\/2\ Dimension[x + z]\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["PoissonKernelH", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(PoissonKernelH[z_, w_] := \((makeVector[z]; 
        makeVector[
          w]; \((2\ \((z . Delta[Dimension[z]] + 
                  w . Delta[Dimension[z]])\))\)/\((\((Dimension[z]\ Volume[
                    Dimension[z]])\)\ \((Norm[z]\^2 + Norm[w]\^2 - 2\ z . w + 
                    4\ z . Delta[Dimension[z]]\ w . 
                        Delta[Dimension[
                            z]])\)^\((Dimension[z]\/2)\))\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(PoissonKernelH[x_, y_, t_, u_] := \((makeVector[x]; makeVector[t]; 
        unmakeVector[y]; 
        unmakeVector[
          u]; \((2\ \((y + 
                  u)\))\)/\((\((\((Dimension[x] + 1)\)\ Volume[
                    Dimension[x] + 
                      1])\)\ \((Norm[x - t]\^2 + \((y + u)\)\^2)\)\^\(1\/2\ \
\((Dimension[x] + 1)\)\))\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["BergmanKernel", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanKernel[x_, y_] := \((makeVector[x]; makeVector[y]; 
        With[{n = 
              Dimension[
                x + y]}, \(n + \((8\ x . y - 2\ n - 4)\)\ Norm[x]\^2\ Norm[y]\
\^2 + \((n - 4)\)\ Norm[x]\^4\ Norm[y]\^4\)\/\(n\ Volume[n]\ \((1 - 2\ x . y \
+ Norm[x]\^2\ Norm[y]\^2)\)\^\(1 + n\/2\)\)])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["BergmanKernelH", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanKernelH[z_, w_] := \((makeVector[z]; makeVector[w]; 
        With[{n = 
              Dimension[
                z + w]}, \((4\ \((n\ \((\((z . Delta[n])\)\^2 + \((w . \
Delta[n])\)\^2)\) - Norm[z]\^2 - Norm[w]\^2 + 
                    2\ z . w + \((2\ n - 4)\)\ z . Delta[n]\ w . 
                        Delta[n])\))\)/\((n\ Volume[
                  n]\ \((Norm[z]\^2 + Norm[w]\^2 - 2\ z . w + 4\ z . Delta[n]\
\ w . Delta[n])\)\^\(1 + n\/2\))\)])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(BergmanKernelH[x_, y_, t_, u_] := \((makeVector[x]; makeVector[t]; 
        unmakeVector[t]; unmakeVector[u]; 
        With[{n = 
              Dimension[x] + 
                1}, \(4\ \((\((n - 1)\)\ \((y + u)\)\^2 - Norm[x - t]\^2)\)\)\
\/\(n\ Volume[n]\ \((Norm[x - t]\^2 + \((y + u)\)\^2)\)\^\(1 + \
n\/2\)\)])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Miscellaneous\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["HarmonicConjugate", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(HarmonicConjugate[u_, x_Symbol, y_Symbol] := \((unmakeVector[x]; 
        unmakeVector[
          y]; \[Integral]\_0\%y\[PartialD]\_x 
                u \[DifferentialD]y - \[Integral]\_0\%x\((\[PartialD]\_y u /. 
                  y \[Rule] 0)\) \[DifferentialD]x)\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["BergmanProjection", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanProjection[0, x_] := 0\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(BergmanProjection[u_, x_Symbol] := \((makeVector[x]; 
        Plus @@ \(\((Plus @@ #1 &)\) /@ \(\((\(Function[
                        j, \(\((Dimension[x] + 2\ #1\[LeftDoubleBracket]2\
\[RightDoubleBracket])\)\ \
#1\[LeftDoubleBracket]1\[RightDoubleBracket]\)\/\(#1\[LeftDoubleBracket]2\
\[RightDoubleBracket] + j + Dimension[x]\) &]\)[#1\[LeftDoubleBracket]2\
\[RightDoubleBracket]] /@ #1\[LeftDoubleBracket]1\[RightDoubleBracket] &)\) /@ \
\(\(({polynomialDecomposition[#1\[LeftDoubleBracket]1\[RightDoubleBracket], 
                        x], #1\[LeftDoubleBracket]2\[RightDoubleBracket]} \
&)\) /@ \(\(({Dirichlet[#1\[LeftDoubleBracket]1\[RightDoubleBracket], 
                          x], #1\[LeftDoubleBracket]2\[RightDoubleBracket]} \
&)\) /@ polynomialDecomposition[u, x]\)\)\)\))\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(BergmanProjection[u_, v_List] := 
      explicit[BergmanProjection, u, v]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Schwarz", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Schwarz[0] = 0;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Schwarz[x_] := 
      PowerExpand[
        Simplify[\((If[Head[x] == List, 
                unmakeVector[
                  x]]; \(Module[{t, u}, 
                    With[{s = 
                          Integrate[
                            Cos[u]\^\(Dimension[x] - 2\)\/\((1 + 1\/t\^2 - \
\(2\ Sin[u]\)\/t)\)\^\(Dimension[x]\/2\), \ {u, 0, Pi/2}, 
                            GenerateConditions \[Rule] False]}, 
                      Together[\((\((1 - 1\/t\^2)\)\ \((Dimension[x] - 
                                    1)\)\ Volume[
                                  Dimension[x] - 
                                    1]\ \((s - \((s /. 
                                        t \[Rule] \
\(-t\))\))\))\)/\((Dimension[x]\ Volume[Dimension[x]])\) /. 
                          t \[Rule] 1\/Norm[x]]]] /. 
                  HoldPattern[\(+t_\)] \[RuleDelayed] 
                    Factor[Select[\(+t\), FreeQ[#1, ArcTan] &]] + 
                      Factor[Select[\(+t\), \(\(\[InvisibleSpace]\)\(! \
\((FreeQ[#1, ArcTan])\)\)\) &]]\) /. \((\(-1\) + t_)\)\ \((1 + 
                        t_)\) \[Rule] \(-\((1 - 
                        t\^2)\)\))\)] /. \ \((\(-1\) + Norm[x])\)\^p_?EvenQ \
\[RuleDelayed] \((1 - Norm[x])\)\^p]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["IntegerQ", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(IntegerQ[m_?IntegerQ + n_?IntegerQ] = True;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(IntegerQ[m_?IntegerQ\ n_?IntegerQ] = True;\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Times", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\
Format[ HoldPattern[Times[a__]]   /; 
  Or @@ Thread[ vector[{a}] ] ]  :=
  With[ {t = Position[ Thread[ vector[{a}] ], True ][[1,1]]},
  SequenceForm[ If[ Head[Times @@ Delete[ {a}, t ]] === Plus, 
  SequenceForm[ \"(\", First[Delete[ {a}, t ]], \")\"],
  Times @@ Delete[ {a}, t ] ], \" \", 
  If[Head[{a}[[t]]] === Plus, SequenceForm[\"(\",{a}[[t]],\")\"], {a}[[t]] ]
  ] ]\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
Format[ HoldPattern[Times[a__]]   /; 
  Or @@ Thread[ matrix[{a}] ] ]  :=
  With[ {t = Position[ Thread[ matrix[{a}] ], True ][[1,1]]},
  SequenceForm[ If[ Head[Times @@ Delete[ {a}, t ]] === Plus, 
  SequenceForm[ \"(\", First[Delete[ {a}, t ]], \")\"],
  Times @@ Delete[ {a}, t ] ], \" \", 
  If[Head[{a}[[t]]] === Plus, SequenceForm[\"(\",{a}[[t]],\")\"], {a}[[t]] ]
  ] ]\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["explicit", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(explicit[function_, f_, v_List, \ opt___] := \((unmakeVector[v]; 
        Module[{z}, setDimension[z, Length[v]]; 
          function[f /. Thread[v \[Rule] Table[\ z\_j, \ {j, Length[v]}]], 
              z, \ Sequence\  @@ \ \(({opt}\  /. 
                    Thread[v \[Rule] Table[\ z\_j, \ {j, Length[v]}]])\)] /. 
            Append[Thread[Table[\ z\_j, \ {j, Length[v]}] \[Rule] v], 
              z \[Rule] v]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(explicit[function_, f_, g_, v_List] := \((unmakeVector[v]; 
        Module[{z}, setDimension[z, Length[v]]; 
          function[f /. Thread[v \[Rule] Table[\ z\_j, \ {j, Length[v]}]], 
              g /. Thread[v \[Rule] Table[\ z\_j, \ {j, Length[v]}]], z] /. 
            Append[Thread[Table[\ z\_j, \ {j, Length[v]}] \[Rule] v], 
              z \[Rule] v]])\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Closing\)], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False,
  FontWeight->"Bold"],

Cell[BoxData[
    \(\(Protect[Release[protectedWords]];\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(End[]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[OutputFormData["\<\
*)
EndPackage[ ]
(*\
\>", "\<\
EndPackage[]\
\>"], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Print["\<* You can now use the functions in this package.\>"]\)], \
"Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1600}, {0, 1127}},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{776, 1045},
WindowMargins->{{Automatic, 58}, {Automatic, 8}},
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 85, 3, 105, "Title",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1886, 60, 121, 4, 64, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2032, 68, 89, 3, 90, "Section",
  Evaluatable->False],
Cell[2124, 73, 355, 6, 140, "Input",
  InitializationCell->True],
Cell[2482, 81, 106, 2, 35, "Input",
  InitializationCell->True],
Cell[2591, 85, 316, 5, 119, "Input",
  InitializationCell->True],
Cell[2910, 92, 238, 4, 77, "Input",
  InitializationCell->True],
Cell[3151, 98, 312, 5, 119, "Input",
  InitializationCell->True],
Cell[3466, 105, 167, 3, 56, "Input",
  InitializationCell->True],
Cell[3636, 110, 126, 3, 35, "Input",
  InitializationCell->True],
Cell[3765, 115, 112, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[3914, 123, 89, 3, 90, "Section",
  Evaluatable->False],
Cell[4006, 128, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[4173, 134, 255, 5, 98, "Input",
  InitializationCell->True],
Cell[4431, 141, 199, 4, 77, "Input",
  InitializationCell->True],
Cell[4633, 147, 237, 5, 77, "Input",
  InitializationCell->True],
Cell[4873, 154, 210, 4, 77, "Input",
  InitializationCell->True],
Cell[5086, 160, 218, 4, 77, "Input",
  InitializationCell->True],
Cell[5307, 166, 304, 5, 98, "Input",
  InitializationCell->True],
Cell[5614, 173, 236, 5, 77, "Input",
  InitializationCell->True],
Cell[5853, 180, 218, 4, 56, "Input",
  InitializationCell->True],
Cell[6074, 186, 167, 4, 35, "Input",
  InitializationCell->True],
Cell[6244, 192, 247, 5, 77, "Input",
  InitializationCell->True],
Cell[6494, 199, 264, 5, 77, "Input",
  InitializationCell->True],
Cell[6761, 206, 193, 4, 56, "Input",
  InitializationCell->True],
Cell[6957, 212, 172, 4, 56, "Input",
  InitializationCell->True],
Cell[7132, 218, 233, 5, 77, "Input",
  InitializationCell->True],
Cell[7368, 225, 281, 5, 98, "Input",
  InitializationCell->True],
Cell[7652, 232, 249, 5, 98, "Input",
  InitializationCell->True],
Cell[7904, 239, 179, 4, 56, "Input",
  InitializationCell->True],
Cell[8086, 245, 237, 5, 77, "Input",
  InitializationCell->True],
Cell[8326, 252, 252, 5, 98, "Input",
  InitializationCell->True],
Cell[8581, 259, 198, 4, 56, "Input",
  InitializationCell->True],
Cell[8782, 265, 216, 4, 77, "Input",
  InitializationCell->True],
Cell[9001, 271, 180, 4, 56, "Input",
  InitializationCell->True],
Cell[9184, 277, 219, 4, 77, "Input",
  InitializationCell->True],
Cell[9406, 283, 285, 5, 98, "Input",
  InitializationCell->True],
Cell[9694, 290, 210, 4, 56, "Input",
  InitializationCell->True],
Cell[9907, 296, 173, 4, 35, "Input",
  InitializationCell->True],
Cell[10083, 302, 204, 4, 56, "Input",
  InitializationCell->True],
Cell[10290, 308, 223, 4, 56, "Input",
  InitializationCell->True],
Cell[10516, 314, 190, 4, 56, "Input",
  InitializationCell->True],
Cell[10709, 320, 343, 6, 98, "Input",
  InitializationCell->True],
Cell[11055, 328, 305, 5, 98, "Input",
  InitializationCell->True],
Cell[11363, 335, 189, 5, 56, "Input",
  InitializationCell->True],
Cell[11555, 342, 237, 5, 77, "Input",
  InitializationCell->True],
Cell[11795, 349, 447, 7, 161, "Input",
  InitializationCell->True],
Cell[12245, 358, 204, 4, 56, "Input",
  InitializationCell->True],
Cell[12452, 364, 230, 5, 56, "Input",
  InitializationCell->True],
Cell[12685, 371, 188, 4, 56, "Input",
  InitializationCell->True],
Cell[12876, 377, 210, 4, 77, "Input",
  InitializationCell->True],
Cell[13089, 383, 233, 5, 56, "Input",
  InitializationCell->True],
Cell[13325, 390, 152, 4, 35, "Input",
  InitializationCell->True],
Cell[13480, 396, 131, 3, 35, "Input",
  InitializationCell->True],
Cell[13614, 401, 267, 5, 77, "Input",
  InitializationCell->True],
Cell[13884, 408, 172, 4, 56, "Input",
  InitializationCell->True],
Cell[14059, 414, 203, 4, 77, "Input",
  InitializationCell->True],
Cell[14265, 420, 203, 4, 77, "Input",
  InitializationCell->True],
Cell[14471, 426, 228, 5, 77, "Input",
  InitializationCell->True],
Cell[14702, 433, 207, 4, 56, "Input",
  InitializationCell->True],
Cell[14912, 439, 272, 5, 98, "Input",
  InitializationCell->True],
Cell[15187, 446, 150, 4, 35, "Input",
  InitializationCell->True],
Cell[15340, 452, 145, 3, 35, "Input",
  InitializationCell->True],
Cell[15488, 457, 210, 4, 56, "Input",
  InitializationCell->True],
Cell[15701, 463, 269, 5, 98, "Input",
  InitializationCell->True],
Cell[15973, 470, 207, 4, 77, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[16217, 479, 94, 3, 90, "Section",
  Evaluatable->False],
Cell[16314, 484, 110, 3, 35, "Input",
  InitializationCell->True],
Cell[16427, 489, 124, 3, 35, "Input",
  InitializationCell->True],
Cell[16554, 494, 193, 5, 56, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[16784, 504, 89, 3, 90, "Section",
  Evaluatable->False],
Cell[16876, 509, 124, 3, 35, "Input",
  InitializationCell->True],
Cell[17003, 514, 123, 3, 35, "Input",
  InitializationCell->True],
Cell[17129, 519, 129, 3, 35, "Input",
  InitializationCell->True],
Cell[17261, 524, 129, 3, 35, "Input",
  InitializationCell->True],
Cell[17393, 529, 125, 3, 35, "Input",
  InitializationCell->True],
Cell[17521, 534, 135, 3, 35, "Input",
  InitializationCell->True],
Cell[17659, 539, 242, 6, 72, "Input",
  InitializationCell->True],
Cell[17904, 547, 297, 6, 77, "Input",
  InitializationCell->True],
Cell[18204, 555, 197, 5, 35, "Input",
  InitializationCell->True],
Cell[18404, 562, 122, 3, 35, "Input",
  InitializationCell->True],
Cell[18529, 567, 166, 4, 35, "Input",
  InitializationCell->True],
Cell[18698, 573, 217, 4, 56, "Input",
  InitializationCell->True],
Cell[18918, 579, 217, 4, 56, "Input",
  InitializationCell->True],
Cell[19138, 585, 156, 4, 35, "Input",
  InitializationCell->True],
Cell[19297, 591, 158, 4, 35, "Input",
  InitializationCell->True],
Cell[19458, 597, 211, 4, 56, "Input",
  InitializationCell->True],
Cell[19672, 603, 211, 4, 56, "Input",
  InitializationCell->True],
Cell[19886, 609, 152, 4, 35, "Input",
  InitializationCell->True],
Cell[20041, 615, 154, 4, 35, "Input",
  InitializationCell->True],
Cell[20198, 621, 399, 9, 119, "Input",
  InitializationCell->True],
Cell[20600, 632, 389, 9, 98, "Input",
  InitializationCell->True],
Cell[20992, 643, 135, 3, 35, "Input",
  InitializationCell->True],
Cell[21130, 648, 106, 2, 35, "Input",
  InitializationCell->True],
Cell[21239, 652, 343, 8, 119, "Input",
  InitializationCell->True],
Cell[21585, 662, 345, 8, 119, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21979, 676, 125, 4, 66, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22129, 684, 98, 3, 90, "Section",
  Evaluatable->False],
Cell[22230, 689, 93, 2, 35, "Input",
  InitializationCell->True],
Cell[22326, 693, 126, 3, 35, "Input",
  InitializationCell->True],
Cell[22455, 698, 135, 3, 35, "Input",
  InitializationCell->True],
Cell[22593, 703, 133, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[22763, 711, 93, 3, 52, "Section",
  Evaluatable->False],
Cell[22859, 716, 87, 2, 35, "Input",
  InitializationCell->True],
Cell[22949, 720, 114, 3, 35, "Input",
  InitializationCell->True],
Cell[23066, 725, 116, 3, 35, "Input",
  InitializationCell->True],
Cell[23185, 730, 134, 3, 35, "Input",
  InitializationCell->True],
Cell[23322, 735, 130, 3, 35, "Input",
  InitializationCell->True],
Cell[23455, 740, 137, 3, 35, "Input",
  InitializationCell->True],
Cell[23595, 745, 108, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[23740, 753, 86, 3, 52, "Section",
  Evaluatable->False],
Cell[23829, 758, 115, 3, 52, "Input",
  InitializationCell->True],
Cell[23947, 763, 113, 3, 52, "Input",
  InitializationCell->True],
Cell[24063, 768, 122, 3, 52, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[24222, 776, 88, 3, 52, "Section",
  Evaluatable->False],
Cell[24313, 781, 130, 3, 35, "Input",
  InitializationCell->True],
Cell[24446, 786, 303, 6, 56, "Input",
  InitializationCell->True],
Cell[24752, 794, 170, 4, 40, "Input",
  InitializationCell->True],
Cell[24925, 800, 170, 4, 39, "Input",
  InitializationCell->True],
Cell[25098, 806, 144, 3, 35, "Input",
  InitializationCell->True],
Cell[25245, 811, 131, 3, 35, "Input",
  InitializationCell->True],
Cell[25379, 816, 127, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[25543, 824, 102, 3, 90, "Section",
  Evaluatable->False],
Cell[25648, 829, 79, 2, 35, "Input",
  InitializationCell->True],
Cell[25730, 833, 114, 2, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[25881, 840, 94, 3, 90, "Section",
  Evaluatable->False],
Cell[25978, 845, 203, 6, 39, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[26218, 856, 87, 3, 52, "Section",
  Evaluatable->False],
Cell[26308, 861, 121, 3, 35, "Input",
  InitializationCell->True],
Cell[26432, 866, 140, 3, 42, "Input",
  InitializationCell->True],
Cell[26575, 871, 261, 6, 94, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[26873, 882, 90, 3, 90, "Section",
  Evaluatable->False],
Cell[26966, 887, 199, 5, 52, "Input",
  InitializationCell->True],
Cell[27168, 894, 149, 4, 52, "Input",
  InitializationCell->True],
Cell[27320, 900, 125, 3, 52, "Input",
  InitializationCell->True],
Cell[27448, 905, 125, 3, 52, "Input",
  InitializationCell->True],
Cell[27576, 910, 118, 3, 52, "Input",
  InitializationCell->True],
Cell[27697, 915, 118, 3, 52, "Input",
  InitializationCell->True],
Cell[27818, 920, 98, 3, 52, "Input",
  InitializationCell->True],
Cell[27919, 925, 142, 3, 53, "Input",
  InitializationCell->True],
Cell[28064, 930, 117, 3, 52, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[28218, 938, 94, 3, 52, "Section",
  Evaluatable->False],
Cell[28315, 943, 104, 3, 35, "Input",
  InitializationCell->True],
Cell[28422, 948, 118, 3, 35, "Input",
  InitializationCell->True],
Cell[28543, 953, 213, 5, 77, "Input",
  InitializationCell->True],
Cell[28759, 960, 131, 3, 35, "Input",
  InitializationCell->True],
Cell[28893, 965, 142, 3, 35, "Input",
  InitializationCell->True],
Cell[29038, 970, 846, 19, 100, "Input",
  InitializationCell->True],
Cell[29887, 991, 141, 3, 36, "Input",
  InitializationCell->True],
Cell[30031, 996, 129, 3, 35, "Input",
  InitializationCell->True],
Cell[30163, 1001, 389, 8, 120, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[30589, 1014, 90, 3, 90, "Section",
  Evaluatable->False],
Cell[30682, 1019, 150, 4, 35, "Input",
  InitializationCell->True],
Cell[30835, 1025, 146, 3, 35, "Input",
  InitializationCell->True],
Cell[30984, 1030, 125, 3, 35, "Input",
  InitializationCell->True],
Cell[31112, 1035, 118, 3, 35, "Input",
  InitializationCell->True],
Cell[31233, 1040, 110, 3, 35, "Input",
  InitializationCell->True],
Cell[31346, 1045, 100, 3, 35, "Input",
  InitializationCell->True],
Cell[31449, 1050, 122, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[31608, 1058, 94, 3, 52, "Section",
  Evaluatable->False],
Cell[31705, 1063, 105, 3, 52, "Input",
  InitializationCell->True],
Cell[31813, 1068, 250, 6, 83, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[32100, 1079, 87, 3, 52, "Section",
  Evaluatable->False],
Cell[32190, 1084, 118, 3, 35, "Input",
  InitializationCell->True],
Cell[32311, 1089, 84, 2, 35, "Input",
  InitializationCell->True],
Cell[32398, 1093, 84, 2, 35, "Input",
  InitializationCell->True],
Cell[32485, 1097, 158, 4, 35, "Input",
  InitializationCell->True],
Cell[32646, 1103, 160, 4, 35, "Input",
  InitializationCell->True],
Cell[32809, 1109, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[32976, 1115, 162, 4, 35, "Input",
  InitializationCell->True],
Cell[33141, 1121, 166, 4, 35, "Input",
  InitializationCell->True],
Cell[33310, 1127, 163, 4, 35, "Input",
  InitializationCell->True],
Cell[33476, 1133, 124, 3, 36, "Input",
  InitializationCell->True],
Cell[33603, 1138, 151, 3, 36, "Input",
  InitializationCell->True],
Cell[33757, 1143, 239, 4, 57, "Input",
  InitializationCell->True],
Cell[33999, 1149, 214, 4, 57, "Input",
  InitializationCell->True],
Cell[34216, 1155, 123, 3, 35, "Input",
  InitializationCell->True],
Cell[34342, 1160, 168, 4, 35, "Input",
  InitializationCell->True],
Cell[34513, 1166, 168, 4, 35, "Input",
  InitializationCell->True],
Cell[34684, 1172, 213, 5, 56, "Input",
  InitializationCell->True],
Cell[34900, 1179, 213, 5, 56, "Input",
  InitializationCell->True],
Cell[35116, 1186, 141, 3, 35, "Input",
  InitializationCell->True],
Cell[35260, 1191, 138, 3, 35, "Input",
  InitializationCell->True],
Cell[35401, 1196, 141, 3, 35, "Input",
  InitializationCell->True],
Cell[35545, 1201, 130, 3, 35, "Input",
  InitializationCell->True],
Cell[35678, 1206, 130, 3, 35, "Input",
  InitializationCell->True],
Cell[35811, 1211, 133, 3, 36, "Input",
  InitializationCell->True],
Cell[35947, 1216, 135, 3, 36, "Input",
  InitializationCell->True],
Cell[36085, 1221, 133, 3, 36, "Input",
  InitializationCell->True],
Cell[36221, 1226, 135, 3, 36, "Input",
  InitializationCell->True],
Cell[36359, 1231, 163, 4, 35, "Input",
  InitializationCell->True],
Cell[36525, 1237, 163, 4, 35, "Input",
  InitializationCell->True],
Cell[36691, 1243, 180, 4, 35, "Input",
  InitializationCell->True],
Cell[36874, 1249, 163, 4, 35, "Input",
  InitializationCell->True],
Cell[37040, 1255, 210, 5, 35, "Input",
  InitializationCell->True],
Cell[37253, 1262, 208, 5, 35, "Input",
  InitializationCell->True],
Cell[37464, 1269, 573, 11, 119, "Input",
  InitializationCell->True],
Cell[38040, 1282, 201, 5, 56, "Input",
  InitializationCell->True],
Cell[38244, 1289, 201, 5, 56, "Input",
  InitializationCell->True],
Cell[38448, 1296, 268, 7, 77, "Input",
  InitializationCell->True],
Cell[38719, 1305, 255, 6, 77, "Input",
  InitializationCell->True],
Cell[38977, 1313, 237, 5, 77, "Input",
  InitializationCell->True],
Cell[39217, 1320, 159, 4, 35, "Input",
  InitializationCell->True],
Cell[39379, 1326, 125, 3, 35, "Input",
  InitializationCell->True],
Cell[39507, 1331, 119, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[39663, 1339, 90, 3, 52, "Section",
  Evaluatable->False],
Cell[39756, 1344, 174, 5, 35, "Input",
  InitializationCell->True],
Cell[39933, 1351, 121, 3, 35, "Input",
  InitializationCell->True],
Cell[40057, 1356, 161, 4, 35, "Input",
  InitializationCell->True],
Cell[40221, 1362, 139, 3, 36, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[40397, 1370, 93, 3, 52, "Section",
  Evaluatable->False],
Cell[40493, 1375, 210, 5, 38, "Input",
  InitializationCell->True],
Cell[40706, 1382, 340, 7, 77, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[41083, 1394, 144, 4, 88, "Section",
  Evaluatable->False],
Cell[41230, 1400, 125, 3, 35, "Input",
  InitializationCell->True],
Cell[41358, 1405, 819, 18, 203, "Input",
  InitializationCell->True],
Cell[42180, 1425, 269, 6, 99, "Input",
  InitializationCell->True],
Cell[42452, 1433, 156, 3, 35, "Input",
  InitializationCell->True],
Cell[42611, 1438, 173, 4, 35, "Input",
  InitializationCell->True],
Cell[42787, 1444, 168, 3, 56, "Input",
  InitializationCell->True],
Cell[42958, 1449, 406, 8, 119, "Input",
  InitializationCell->True],
Cell[43367, 1459, 211, 4, 56, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[43615, 1468, 89, 3, 52, "Section",
  Evaluatable->False],
Cell[43707, 1473, 113, 3, 35, "Input",
  InitializationCell->True],
Cell[43823, 1478, 125, 3, 35, "Input",
  InitializationCell->True],
Cell[43951, 1483, 116, 3, 35, "Input",
  InitializationCell->True],
Cell[44070, 1488, 120, 3, 35, "Input",
  InitializationCell->True],
Cell[44193, 1493, 112, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[44342, 1501, 91, 3, 52, "Section",
  Evaluatable->False],
Cell[44436, 1506, 137, 3, 40, "Input",
  InitializationCell->True],
Cell[44576, 1511, 142, 3, 35, "Input",
  InitializationCell->True],
Cell[44721, 1516, 217, 5, 56, "Input",
  InitializationCell->True],
Cell[44941, 1523, 237, 6, 77, "Input",
  InitializationCell->True],
Cell[45181, 1531, 149, 4, 40, "Input",
  InitializationCell->True],
Cell[45333, 1537, 161, 4, 35, "Input",
  InitializationCell->True],
Cell[45497, 1543, 149, 4, 40, "Input",
  InitializationCell->True],
Cell[45649, 1549, 108, 3, 35, "Input",
  InitializationCell->True],
Cell[45760, 1554, 140, 3, 40, "Input",
  InitializationCell->True],
Cell[45903, 1559, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[46070, 1565, 146, 3, 35, "Input",
  InitializationCell->True],
Cell[46219, 1570, 261, 5, 77, "Input",
  InitializationCell->True],
Cell[46483, 1577, 281, 6, 57, "Input",
  InitializationCell->True],
Cell[46767, 1585, 180, 5, 36, "Input",
  InitializationCell->True],
Cell[46950, 1592, 672, 17, 103, "Input",
  InitializationCell->True],
Cell[47625, 1611, 652, 16, 98, "Input",
  InitializationCell->True],
Cell[48280, 1629, 167, 4, 36, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[48484, 1638, 91, 3, 52, "Section",
  Evaluatable->False],
Cell[48578, 1643, 150, 4, 35, "Input",
  InitializationCell->True],
Cell[48731, 1649, 191, 4, 57, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[48959, 1658, 88, 3, 52, "Section",
  Evaluatable->False],
Cell[49050, 1663, 149, 4, 35, "Input",
  InitializationCell->True],
Cell[49202, 1669, 143, 3, 40, "Input",
  InitializationCell->True],
Cell[49348, 1674, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[49515, 1680, 143, 3, 35, "Input",
  InitializationCell->True],
Cell[49661, 1685, 142, 3, 35, "Input",
  InitializationCell->True],
Cell[49806, 1690, 175, 4, 36, "Input",
  InitializationCell->True],
Cell[49984, 1696, 548, 14, 77, "Input",
  InitializationCell->True],
Cell[50535, 1712, 116, 3, 52, "Input",
  InitializationCell->True],
Cell[50654, 1717, 110, 3, 35, "Input",
  InitializationCell->True],
Cell[50767, 1722, 178, 5, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[50982, 1732, 94, 3, 52, "Section",
  Evaluatable->False],
Cell[51079, 1737, 162, 4, 52, "Input",
  InitializationCell->True],
Cell[51244, 1743, 158, 4, 52, "Input",
  InitializationCell->True],
Cell[51405, 1749, 176, 4, 52, "Input",
  InitializationCell->True],
Cell[51584, 1755, 208, 5, 52, "Input",
  InitializationCell->True],
Cell[51795, 1762, 165, 4, 52, "Input",
  InitializationCell->True],
Cell[51963, 1768, 178, 4, 52, "Input",
  InitializationCell->True],
Cell[52144, 1774, 217, 5, 83, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[52398, 1784, 85, 3, 52, "Section",
  Evaluatable->False],
Cell[52486, 1789, 168, 4, 52, "Input",
  InitializationCell->True],
Cell[52657, 1795, 165, 4, 52, "Input",
  InitializationCell->True],
Cell[52825, 1801, 158, 4, 52, "Input",
  InitializationCell->True],
Cell[52986, 1807, 167, 4, 52, "Input",
  InitializationCell->True],
Cell[53156, 1813, 199, 5, 52, "Input",
  InitializationCell->True],
Cell[53358, 1820, 511, 12, 83, "Input",
  InitializationCell->True],
Cell[53872, 1834, 175, 4, 52, "Input",
  InitializationCell->True],
Cell[54050, 1840, 197, 5, 52, "Input",
  InitializationCell->True],
Cell[54250, 1847, 303, 6, 83, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[54590, 1858, 98, 3, 52, "Section",
  Evaluatable->False],
Cell[54691, 1863, 146, 3, 52, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[54874, 1871, 93, 3, 52, "Section",
  Evaluatable->False],
Cell[54970, 1876, 189, 4, 56, "Input",
  InitializationCell->True],
Cell[55162, 1882, 161, 4, 35, "Input",
  InitializationCell->True],
Cell[55326, 1888, 141, 3, 40, "Input",
  InitializationCell->True],
Cell[55470, 1893, 174, 4, 56, "Input",
  InitializationCell->True],
Cell[55647, 1899, 203, 5, 56, "Input",
  InitializationCell->True],
Cell[55853, 1906, 441, 9, 101, "Input",
  InitializationCell->True],
Cell[56297, 1917, 277, 6, 78, "Input",
  InitializationCell->True],
Cell[56577, 1925, 168, 4, 35, "Input",
  InitializationCell->True],
Cell[56748, 1931, 168, 4, 35, "Input",
  InitializationCell->True],
Cell[56919, 1937, 194, 4, 56, "Input",
  InitializationCell->True],
Cell[57116, 1943, 194, 4, 56, "Input",
  InitializationCell->True],
Cell[57313, 1949, 196, 4, 56, "Input",
  InitializationCell->True],
Cell[57512, 1955, 196, 4, 56, "Input",
  InitializationCell->True],
Cell[57711, 1961, 187, 5, 56, "Input",
  InitializationCell->True],
Cell[57901, 1968, 187, 5, 56, "Input",
  InitializationCell->True],
Cell[58091, 1975, 189, 5, 56, "Input",
  InitializationCell->True],
Cell[58283, 1982, 189, 5, 56, "Input",
  InitializationCell->True],
Cell[58475, 1989, 223, 5, 56, "Input",
  InitializationCell->True],
Cell[58701, 1996, 221, 5, 56, "Input",
  InitializationCell->True],
Cell[58925, 2003, 631, 16, 77, "Input",
  InitializationCell->True],
Cell[59559, 2021, 140, 3, 52, "Input",
  InitializationCell->True],
Cell[59702, 2026, 259, 6, 101, "Input",
  InitializationCell->True],
Cell[59964, 2034, 270, 6, 143, "Input",
  InitializationCell->True],
Cell[60237, 2042, 115, 3, 35, "Input",
  InitializationCell->True],
Cell[60355, 2047, 193, 4, 56, "Input",
  InitializationCell->True],
Cell[60551, 2053, 218, 5, 57, "Input",
  InitializationCell->True],
Cell[60772, 2060, 161, 4, 36, "Input",
  InitializationCell->True],
Cell[60936, 2066, 173, 4, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[61146, 2075, 93, 3, 52, "Section",
  Evaluatable->False],
Cell[61242, 2080, 149, 4, 35, "Input",
  InitializationCell->True],
Cell[61394, 2086, 183, 4, 56, "Input",
  InitializationCell->True],
Cell[61580, 2092, 127, 3, 35, "Input",
  InitializationCell->True],
Cell[61710, 2097, 244, 6, 77, "Input",
  InitializationCell->True],
Cell[61957, 2105, 122, 3, 35, "Input",
  InitializationCell->True],
Cell[62082, 2110, 186, 4, 35, "Input",
  InitializationCell->True],
Cell[62271, 2116, 119, 3, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[62427, 2124, 96, 3, 52, "Section",
  Evaluatable->False],
Cell[62526, 2129, 153, 3, 56, "Input",
  InitializationCell->True],
Cell[62682, 2134, 671, 13, 203, "Input",
  InitializationCell->True],
Cell[63356, 2149, 174, 3, 77, "Input",
  InitializationCell->True],
Cell[63533, 2154, 239, 5, 77, "Input",
  InitializationCell->True],
Cell[63775, 2161, 468, 9, 140, "Input",
  InitializationCell->True],
Cell[64246, 2172, 201, 4, 77, "Input",
  InitializationCell->True],
Cell[64450, 2178, 643, 13, 203, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[65130, 2196, 95, 3, 90, "Section",
  Evaluatable->False],
Cell[65228, 2201, 560, 11, 143, "Input",
  InitializationCell->True],
Cell[65791, 2214, 455, 9, 140, "Input",
  InitializationCell->True],
Cell[66249, 2225, 376, 7, 121, "Input",
  InitializationCell->True],
Cell[66628, 2234, 313, 7, 98, "Input",
  InitializationCell->True],
Cell[66944, 2243, 964, 20, 184, "Input",
  InitializationCell->True],
Cell[67911, 2265, 200, 5, 56, "Input",
  InitializationCell->True],
Cell[68114, 2272, 383, 8, 100, "Input",
  InitializationCell->True],
Cell[68500, 2282, 342, 7, 119, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[68879, 2294, 117, 3, 52, "Section",
  Evaluatable->False],
Cell[68999, 2299, 135, 3, 35, "Input",
  InitializationCell->True],
Cell[69137, 2304, 116, 3, 35, "Input",
  InitializationCell->True],
Cell[69256, 2309, 126, 3, 35, "Input",
  InitializationCell->True],
Cell[69385, 2314, 239, 5, 77, "Input",
  InitializationCell->True],
Cell[69627, 2321, 165, 4, 35, "Input",
  InitializationCell->True],
Cell[69795, 2327, 170, 4, 35, "Input",
  InitializationCell->True],
Cell[69968, 2333, 311, 6, 98, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[70316, 2344, 90, 3, 52, "Section",
  Evaluatable->False],
Cell[70409, 2349, 208, 5, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[70654, 2359, 90, 3, 52, "Section",
  Evaluatable->False],
Cell[70747, 2364, 164, 4, 92, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[70948, 2373, 95, 3, 52, "Section",
  Evaluatable->False],
Cell[71046, 2378, 172, 4, 92, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[71255, 2387, 97, 3, 52, "Section",
  Evaluatable->False],
Cell[71355, 2392, 299, 7, 77, "Input",
  InitializationCell->True],
Cell[71657, 2401, 202, 5, 56, "Input",
  InitializationCell->True],
Cell[71862, 2408, 312, 7, 77, "Input",
  InitializationCell->True],
Cell[72177, 2417, 669, 14, 225, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[72883, 2436, 99, 3, 52, "Section",
  Evaluatable->False],
Cell[72985, 2441, 303, 7, 77, "Input",
  InitializationCell->True],
Cell[73291, 2450, 513, 11, 182, "Input",
  InitializationCell->True],
Cell[73807, 2463, 182, 4, 56, "Input",
  InitializationCell->True],
Cell[73992, 2469, 132, 3, 35, "Input",
  InitializationCell->True],
Cell[74127, 2474, 126, 3, 40, "Input",
  InitializationCell->True],
Cell[74256, 2479, 167, 4, 35, "Input",
  InitializationCell->True],
Cell[74426, 2485, 165, 4, 40, "Input",
  InitializationCell->True],
Cell[74594, 2491, 171, 4, 56, "Input",
  InitializationCell->True],
Cell[74768, 2497, 195, 5, 58, "Input",
  InitializationCell->True],
Cell[74966, 2504, 134, 3, 35, "Input",
  InitializationCell->True],
Cell[75103, 2509, 198, 5, 52, "Input",
  InitializationCell->True],
Cell[75304, 2516, 278, 6, 57, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[75631, 2528, 132, 4, 66, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[75788, 2536, 77, 2, 92, "Section",
  Evaluatable->False],
Cell[75868, 2540, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[76035, 2546, 612, 12, 203, "Input",
  InitializationCell->True],
Cell[76650, 2560, 441, 9, 161, "Input",
  InitializationCell->True],
Cell[77094, 2571, 839, 16, 224, "Input",
  InitializationCell->True],
Cell[77936, 2589, 344, 7, 78, "Input",
  InitializationCell->True],
Cell[78283, 2598, 183, 4, 35, "Input",
  InitializationCell->True],
Cell[78469, 2604, 158, 4, 35, "Input",
  InitializationCell->True],
Cell[78630, 2610, 113, 3, 35, "Input",
  InitializationCell->True],
Cell[78746, 2615, 1219, 21, 190, "Input",
  InitializationCell->True],
Cell[79968, 2638, 1065, 19, 167, "Input",
  InitializationCell->True],
Cell[81036, 2659, 131, 3, 35, "Input",
  InitializationCell->True],
Cell[81170, 2664, 182, 4, 56, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[81389, 2673, 89, 2, 92, "Section",
  Evaluatable->False],
Cell[81481, 2677, 98, 3, 35, "Input",
  InitializationCell->True],
Cell[81582, 2682, 156, 4, 36, "Input",
  InitializationCell->True],
Cell[81741, 2688, 121, 3, 35, "Input",
  InitializationCell->True],
Cell[81865, 2693, 2325, 42, 749, "Input",
  InitializationCell->True],
Cell[84193, 2737, 168, 4, 56, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[84398, 2746, 81, 2, 92, "Section",
  Evaluatable->False],
Cell[84482, 2750, 171, 4, 35, "Input",
  InitializationCell->True],
Cell[84656, 2756, 132, 3, 35, "Input",
  InitializationCell->True],
Cell[84791, 2761, 611, 11, 183, "Input",
  InitializationCell->True],
Cell[85405, 2774, 973, 17, 227, "Input",
  InitializationCell->True],
Cell[86381, 2793, 181, 4, 56, "Input",
  InitializationCell->True],
Cell[86565, 2799, 631, 12, 182, "Input",
  InitializationCell->True],
Cell[87199, 2813, 233, 5, 77, "Input",
  InitializationCell->True],
Cell[87435, 2820, 675, 12, 245, "Input",
  InitializationCell->True],
Cell[88113, 2834, 101, 2, 35, "Input",
  InitializationCell->True],
Cell[88217, 2838, 307, 6, 98, "Input",
  InitializationCell->True],
Cell[88527, 2846, 186, 4, 35, "Input",
  InitializationCell->True],
Cell[88716, 2852, 1172, 21, 314, "Input",
  InitializationCell->True],
Cell[89891, 2875, 222, 5, 56, "Input",
  InitializationCell->True],
Cell[90116, 2882, 192, 4, 56, "Input",
  InitializationCell->True],
Cell[90311, 2888, 373, 7, 119, "Input",
  InitializationCell->True],
Cell[90687, 2897, 317, 6, 77, "Input",
  InitializationCell->True],
Cell[91007, 2905, 326, 6, 77, "Input",
  InitializationCell->True],
Cell[91336, 2913, 1206, 21, 291, "Input",
  InitializationCell->True],
Cell[92545, 2936, 486, 9, 120, "Input",
  InitializationCell->True],
Cell[93034, 2947, 176, 4, 56, "Input",
  InitializationCell->True],
Cell[93213, 2953, 144, 3, 49, "Input",
  InitializationCell->True],
Cell[93360, 2958, 346, 9, 119, "Input",
  InitializationCell->True],
Cell[93709, 2969, 161, 4, 35, "Input",
  InitializationCell->True],
Cell[93873, 2975, 401, 8, 79, "Input",
  InitializationCell->True],
Cell[94277, 2985, 625, 11, 218, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[94939, 3001, 75, 2, 92, "Section",
  Evaluatable->False],
Cell[95017, 3005, 134, 3, 35, "Input",
  InitializationCell->True],
Cell[95154, 3010, 141, 3, 35, "Input",
  InitializationCell->True],
Cell[95298, 3015, 113, 3, 35, "Input",
  InitializationCell->True],
Cell[95414, 3020, 365, 7, 98, "Input",
  InitializationCell->True],
Cell[95782, 3029, 311, 7, 99, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[96130, 3041, 83, 2, 92, "Section",
  Evaluatable->False],
Cell[96216, 3045, 157, 4, 35, "Input",
  InitializationCell->True],
Cell[96376, 3051, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[96543, 3057, 121, 3, 35, "Input",
  InitializationCell->True],
Cell[96667, 3062, 442, 9, 102, "Input",
  InitializationCell->True],
Cell[97112, 3073, 482, 9, 98, "Input",
  InitializationCell->True],
Cell[97597, 3084, 237, 5, 77, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[97871, 3094, 79, 2, 92, "Section",
  Evaluatable->False],
Cell[97953, 3098, 142, 3, 35, "Input",
  InitializationCell->True],
Cell[98098, 3103, 156, 4, 35, "Input",
  InitializationCell->True],
Cell[98257, 3109, 220, 5, 71, "Input",
  InitializationCell->True],
Cell[98480, 3116, 182, 4, 56, "Input",
  InitializationCell->True],
Cell[98665, 3122, 143, 3, 49, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[98857, 3131, 127, 4, 66, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[99009, 3139, 81, 2, 92, "Section",
  Evaluatable->False],
Cell[99093, 3143, 117, 3, 35, "Input",
  InitializationCell->True],
Cell[99213, 3148, 589, 11, 224, "Input",
  InitializationCell->True],
Cell[99805, 3161, 559, 10, 212, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[100401, 3176, 78, 2, 92, "Section",
  Evaluatable->False],
Cell[100482, 3180, 113, 3, 46, "Input",
  InitializationCell->True],
Cell[100598, 3185, 172, 4, 46, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[100807, 3194, 74, 2, 54, "Section",
  Evaluatable->False],
Cell[100884, 3198, 137, 3, 35, "Input",
  InitializationCell->True],
Cell[101024, 3203, 352, 7, 152, "Input",
  InitializationCell->True],
Cell[101379, 3212, 1247, 23, 371, "Input",
  InitializationCell->True],
Cell[102629, 3237, 1495, 28, 413, "Input",
  InitializationCell->True],
Cell[104127, 3267, 360, 7, 98, "Input",
  InitializationCell->True],
Cell[104490, 3276, 415, 9, 98, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[104942, 3290, 82, 2, 92, "Section",
  Evaluatable->False],
Cell[105027, 3294, 561, 12, 218, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[105637, 3312, 129, 4, 66, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[105791, 3320, 78, 2, 92, "Section",
  Evaluatable->False],
Cell[105872, 3324, 116, 3, 35, "Input",
  InitializationCell->True],
Cell[105991, 3329, 203, 4, 57, "Input",
  InitializationCell->True],
Cell[106197, 3335, 255, 6, 77, "Input",
  InitializationCell->True],
Cell[106455, 3343, 246, 5, 77, "Input",
  InitializationCell->True],
Cell[106704, 3350, 169, 4, 36, "Input",
  InitializationCell->True],
Cell[106876, 3356, 188, 4, 52, "Input",
  InitializationCell->True],
Cell[107067, 3362, 261, 6, 77, "Input",
  InitializationCell->True],
Cell[107331, 3370, 252, 5, 77, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[107620, 3380, 74, 2, 92, "Section",
  Evaluatable->False],
Cell[107697, 3384, 162, 4, 35, "Input",
  InitializationCell->True],
Cell[107862, 3390, 227, 5, 57, "Input",
  InitializationCell->True],
Cell[108092, 3397, 265, 5, 113, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[108394, 3407, 81, 2, 92, "Section",
  Evaluatable->False],
Cell[108478, 3411, 331, 6, 98, "Input",
  InitializationCell->True],
Cell[108812, 3419, 348, 8, 98, "Input",
  InitializationCell->True],
Cell[109163, 3429, 131, 3, 35, "Input",
  InitializationCell->True],
Cell[109297, 3434, 275, 6, 92, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[109609, 3445, 69, 2, 92, "Section",
  Evaluatable->False],
Cell[109681, 3449, 105, 3, 35, "Input",
  InitializationCell->True],
Cell[109789, 3454, 159, 4, 35, "Input",
  InitializationCell->True],
Cell[109951, 3460, 159, 4, 35, "Input",
  InitializationCell->True],
Cell[110113, 3466, 106, 3, 35, "Input",
  InitializationCell->True],
Cell[110222, 3471, 133, 3, 36, "Input",
  InitializationCell->True],
Cell[110358, 3476, 124, 3, 36, "Input",
  InitializationCell->True],
Cell[110485, 3481, 118, 3, 36, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[110640, 3489, 75, 2, 92, "Section",
  Evaluatable->False],
Cell[110718, 3493, 164, 4, 35, "Input",
  InitializationCell->True],
Cell[110885, 3499, 293, 6, 101, "Input",
  InitializationCell->True],
Cell[111181, 3507, 344, 7, 101, "Input",
  InitializationCell->True],
Cell[111528, 3516, 499, 9, 187, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[112076, 3531, 114, 4, 66, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[112215, 3539, 81, 2, 92, "Section",
  Evaluatable->False],
Cell[112299, 3543, 274, 6, 155, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[112610, 3554, 82, 2, 92, "Section",
  Evaluatable->False],
Cell[112695, 3558, 514, 10, 187, "Input",
  InitializationCell->True],
Cell[113212, 3570, 440, 10, 163, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[113689, 3585, 81, 2, 92, "Section",
  Evaluatable->False],
Cell[113773, 3589, 395, 8, 170, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[114205, 3602, 82, 2, 92, "Section",
  Evaluatable->False],
Cell[114290, 3606, 547, 11, 200, "Input",
  InitializationCell->True],
Cell[114840, 3619, 403, 9, 146, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[115292, 3634, 120, 4, 66, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[115437, 3642, 85, 2, 92, "Section",
  Evaluatable->False],
Cell[115525, 3646, 355, 7, 75, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[115917, 3658, 85, 2, 54, "Section",
  Evaluatable->False],
Cell[116005, 3662, 116, 3, 35, "Input",
  InitializationCell->True],
Cell[116124, 3667, 881, 14, 196, "Input",
  InitializationCell->True],
Cell[117008, 3683, 161, 4, 35, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[117206, 3692, 75, 2, 54, "Section",
  Evaluatable->False],
Cell[117284, 3696, 106, 3, 35, "Input",
  InitializationCell->True],
Cell[117393, 3701, 1320, 26, 497, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[118750, 3732, 76, 2, 92, "Section",
  Evaluatable->False],
Cell[118829, 3736, 134, 3, 46, "Input",
  InitializationCell->True],
Cell[118966, 3741, 133, 3, 46, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[119136, 3749, 73, 2, 54, "Section",
  Evaluatable->False],
Cell[119212, 3753, 427, 10, 250, "Input"],
Cell[119642, 3765, 427, 10, 250, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[120106, 3780, 76, 2, 54, "Section",
  Evaluatable->False],
Cell[120185, 3784, 507, 9, 119, "Input",
  InitializationCell->True],
Cell[120695, 3795, 451, 8, 119, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[121195, 3809, 114, 4, 66, "Subtitle",
  Evaluatable->False],
Cell[121312, 3815, 125, 3, 35, "Input",
  InitializationCell->True],
Cell[121440, 3820, 93, 3, 35, "Input",
  InitializationCell->True],
Cell[121536, 3825, 139, 8, 32, "Input",
  InitializationCell->True],
Cell[121678, 3835, 151, 4, 35, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

